#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

RawSerial pc(USBTX,USBRX,9600);

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);



Timeout LedTimeout;

void LedOff(){
    led_red=0;
    }
int my_puts(char tab[],int size)
{
//retutn 0 if string is valid
    bool StringIsValid=false;
    for( int index=0; index<size; index++) {
        if (tab[index]==NULL) {
            StringIsValid = true;
            break;
        }
    }
    if(StringIsValid == false) return(1);

    for( int index=0; index<size; index++) {
        if (tab[index]==NULL) {
            pc.putc('\r');
            while(!pc.writeable());
            pc.putc('\n');
            return(0);
        }
        while(!pc.writeable());
        pc.putc(tab[index]);
    }
    return(0);
}


char my_gets(char str[],int size)
{
    if (!pc.readable())return (NULL);
    char c;
    for(int index=0;index <size; index++) {
        c=pc.getc();
        pc.putc(c);
        if ((c=='\r')||(c=='\n')) {
            pc.putc('\r');
            pc.putc('\n');
            str[index]=NULL;
            return (1);
        }
        str[index]=c;
    }
    LedTimeout.attach(&LedOff, 5);
    led_red=1;
    return (1);
}

int main()
{
    //user_button.rise(&button_pressed);
    //user_button.fall(&button_released);

    //pc.format(8, Serial::None, 1);

    //pc.baud(9600);

    bool flag=false;
    
    const char tekstSize = 7;
    char tekst[tekstSize];
    char tekst2[tekstSize*2];
    char init[] = "system start\r\n";
    my_puts(init,tekstSize);

    

    while(1) {



        if (my_gets(tekst,tekstSize)!=NULL) {
            sprintf(tekst2,"opd: %s %s", tekst,tekst );
            my_puts(tekst2,tekstSize*2);

            if(strcmp(tekst,"on"))flag = true;
            if(strcmp(tekst,"off"))flag = false;
            if(strcmp(tekst,"toggle"))flag = !flag;
            led_green =flag;
        }
    }
}

