#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------
 
RawSerial pc(USBTX,USBRX,9600);

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

InterruptIn user_button(USER_BUTTON);

float delay_on = 0.2;
float delay_off = 1.0;

void button_pressed()
{
    delay_on = 0.1;
    delay_off = 0.1;
}

void button_released()
{
    delay_on = 0.2;
    delay_off = 1.0;
}

int main()
{
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
    
    pc.format(8, Serial::None, 1);
 
    pc.baud(9600);
    
    int i=0;
    
    while(1) {
        
        //pc.printf("This program runs since %d seconds.\r\n", i);
 
      i++;
 
      wait(1);
        /*
        // LEDs are ON
        led_green = 1;
        led_red = 1;
        wait(delay_on);
        // LEDs are OFF
        led_green = 0;
        led_red = 0;
        wait(delay_off);
        */
        for(char a = 'a';a<='z';a++){
            pc.putc(a);
            pc.putc('\r');
            pc.putc('\n');
            wait(0.1);
            }
    }
}
