//#include "mbed.h"
//#include "TS_DISCO_F429ZI.h"
//#include "LCD_DISCO_F429ZI.h"
#include "Keyboard_Ts.h"


TS_DISCO_F429ZI ts;
TS_StateTypeDef TS_State;



KeyboardTs::KeyboardTs(void){
        
    uint8_t status;
        
    status = ts.Init(LedLcd::GetXSize(), LedLcd::GetYSize());

    if (status != TS_OK) {
        LedLcd::Clear(LCD_COLOR_RED);
        LedLcd::SetBackColor(LCD_COLOR_RED);
        LedLcd::SetTextColor(LCD_COLOR_WHITE);
        LedLcd::DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        LedLcd::DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    } else {
        LedLcd::Clear(LCD_COLOR_GREEN);
        LedLcd::SetBackColor(LCD_COLOR_GREEN);
        LedLcd::SetTextColor(LCD_COLOR_WHITE);
        LedLcd::DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        LedLcd::DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }
    wait_ms(500);
    BSP_LCD_SetFont(&Font20);

    LedLcd::Clear(LCD_COLOR_BLACK);
    LedLcd::SetBackColor(LCD_COLOR_BLACK);
    LedLcd::SetTextColor(LCD_COLOR_GREEN);

    for(uint8_t i=0; i<4; i++)
        LedLcd::DrawRect(0,0+80*i,80,80);
}
    
    
bool KeyboardTs::touchInRect(uint16_t TouchXpos, uint16_t TouchYpos,uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height)
{
    if((TouchXpos>=Xpos)&&(TouchXpos<=Xpos+Width)&&(TouchYpos>=Ypos)&&(TouchYpos<=Ypos+Height))return (true);
    else return(false);
}

enum KeyboardState KeyboardTs::eRead(void){
    
    ts.GetState(&TS_State);
    if (TS_State.TouchDetected) {
        x = TS_State.X;
        y = TS_State.Y;
        if(touchInRect(x,y,1,1+80*0,79,79)) return (BUTTON_0);
        if(touchInRect(x,y,1,1+80*1,79,79)) return (BUTTON_1);
        if(touchInRect(x,y,1,1+80*2,79,79)) return (BUTTON_2);
        if(touchInRect(x,y,1,1+80*3,79,79)) return (BUTTON_3);
        return(RELASED);
    }else{
        return(RELASED);
    }
}


