#include "mbed.h"

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

InterruptIn user_button(USER_BUTTON);

float delay_on = 0.2;
float delay_off = 1.0;
enum led {LED_1,LED_2};
enum led eLed=LED_2;
void button_pressed()
{
    eLed=LED_1;
    delay_on = 0.2;
    delay_off = 0.2;
}

void button_released()
{
    eLed=LED_2;
    delay_on = 0.2;
    delay_off = 0.2;
}

int main()
{
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);

    while(1) {
        // LEDs are ON
        if(eLed == LED_1)
            led_green = 1;
        else
            led_red = 1;
        wait(delay_on);
        // LEDs are OFF

        led_green = 0;
        led_red = 0;
        wait(delay_off);
    }
}
