#include "mbed.h"
#include "TS_DISCO_F429ZI.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;
bool touchInRect(uint16_t TouchXpos, uint16_t TouchYpos,uint16_t Xpos, uint16_t Ypos, uint16_t Width, uint16_t Height)
{
    if((TouchXpos>=Xpos)&&(TouchXpos<=Xpos+Width)&&(TouchYpos>=Ypos)&&(TouchYpos<=Ypos+Height))return (true);
    else return(false);
}

void drawNumber()
{
    uint8_t text[3];
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.SetBackColor(LCD_COLOR_RED);
    for(uint8_t i=0; i<4; i++) {
        sprintf((char*)text, "%d", i);
        lcd.DisplayStringAt(0, 0+i*80, (uint8_t *)&text, LEFT_MODE);
    }
    lcd.SetBackColor(LCD_COLOR_BLACK);
}
int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    bool UpdateAfterTouch=true;

    BSP_LCD_SetFont(&Font20);

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"DEMO", CENTER_MODE);
    wait_ms(500);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());

    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN", CENTER_MODE);
        lcd.DisplayStringAt(0, LINE(6), (uint8_t *)"INIT OK", CENTER_MODE);
    }

    wait_ms(500);


    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);

    for(uint8_t i=0; i<4; i++)
        lcd.DrawRect(0,0+80*i,80,80);

    lcd.SetFont(&Font24);

    while(1) {
        wait_ms(100);


        ts.GetState(&TS_State);
        if (TS_State.TouchDetected) {
            UpdateAfterTouch=true;
            x = TS_State.X;
            y = TS_State.Y;
            lcd.SetTextColor(LCD_COLOR_GREEN);
            for(uint8_t i=0; i<4; i++)
                if(touchInRect(x,y,1,1+80*i,79,79))
                    lcd.FillRect(1,1+80*i,79,79);
            drawNumber();
        } else if(UpdateAfterTouch == true) {
            UpdateAfterTouch=false;
            lcd.SetTextColor(LCD_COLOR_BLUE);
            for(uint8_t i=0; i<4; i++)
                lcd.FillRect(1,1+80*i,79,79);
            drawNumber();
        }


    }
}
