#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "143.129.39.151"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
        The function someFunction(void) is called when this interrupt occurs.
    -   Before implementing MQTT, test the multiclick feature first.
        You can simply use 'printf()' to print to a serial terminal. The baud rate is 9600.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

InterruptIn button(USER_BUTTON);
DigitalOut myled(LED1);
EthernetInterface eth_interface;
MQTTNetwork network(&eth_interface);
MQTT::Client<MQTTNetwork, Countdown> client(network);
char* topic = "clubIOT/feedback";
char* subTopic = "clubIOT/songmeta

/**
    called when the button generates an interrupt
*/
void buttonPress()
{
    button1_pressed=true;
}

/**
    called to initialize MQTT
*/
void initMQTT()
{
    eth_interface.connect();
    if(eth_interface.get_ip_address() == NULL)
        printf("ip adres kaput \r\n");
    else
        printf("IP: %s\r\n", eth_interface.get_ip_address());
    const char* hostname = BROKER_NAME;
    int port = BROKER_PORT;
    int rc = network.connect(hostname, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\r\n", rc);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "robrecht";
    data.username.cstring = "smartcity";
    data.password.cstring = "smartcity";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
    else
        printf("connected\r\n");   
}

/**
    send a message over MQTT
*/
void sendMessage(MQTT::Client<MQTTNetwork, Countdown> *client, char* tempTopic, char* buf ,int qos, bool retained, bool duplicate)
{
    MQTT::Message message;
    if(qos==0)
        message.qos= MQTT::QOS0;
    else if(qos==1)
        message.qos= MQTT::QOS1;
    else 
        message.qos= MQTT::QOS2;
    message.retained=retained;
    message.dup=duplicate;
    message.payload= (void*) buf;
    message.payloadlen = strlen(buf)+1;
    client->publish(tempTopic, message);
}

/**
    disconnect from MQTT
*/
void disconnect()
{
    char buf[100];
    sprintf(buf, "disconnect");
    sendMessage(&client, topic, buf, 0, false, false);
    client.disconnect();
    eth_interface.disconnect();
}

/**
    Called when the controller receives a song
*/
void printMessage(MQTT::MessageData& data)
{
    printf("MQTT message: %s\r\n", data.message.payload);    
}

int main(int argc, char* argv[])
{    
    initMQTT();
    button.fall(callback(&buttonPress));
    client.subscribe(subTopic, MQTT::QOS1, printMessage);
    
    while(1)
    {
        if(button1_pressed){
            button1_pressed = false;
            button1_onpressed_cb();
        }
        if(!button1_busy && result_ready){
            result_ready=false;
            printf("The button was pressed %d times in the last second \r\n", last_multiclick_state);
            char buf[100];
            if(last_multiclick_state==1){
                sprintf(buf, "like");
                sendMessage(&client, topic, buf, 0, false, false);
            }
            else if(last_multiclick_state==2){
                sprintf(buf, "dislike");
                sendMessage(&client, topic, buf, 0, false, false);
            }
            else if(last_multiclick_state==4){
                disconnect();
                return 0;
            }
        }
    }
    return 0;
}
