#include "debounce_button.h"

/**
    TODO
    ----
    -   A debouncer has to be present: the built-in buttons of the Nucleo aren't that good, so false positives have to be filtered out. 
        Find a method such that false calls of this function are going to be filtered out. 
        The main loop also needs to know when it can process the further instructions.
        An acceptable time to disable further false positives is between 50ms and 100ms.
    -   The user needs to be able to click the button multiple times in 1 second. 
        The main loop needs to know how many times the user has pressed the button, such that
        it can link different procedures to the different multiclicks. The main loop also needs
        to know when this function is counting the clicks. Therefore, it has to wait until the clicks have been counted
        before it can proceed.
    -   LED1 needs to be turned on while the function is counting the amount of clicks within 1 second.
    
    Some tips and tricks:
    -   To use the built-in LED:
            DigitalOut led1(LED1);
            ...
            led1 = 1;
    -   To delay the call of a function:
            Timeout someTimeout;
            ...
            someTimeout.attach(callback(&anotherFunction), 0.5) with 0.5 as 500 milliseconds
    -   The variables that are used in interrupt callbacks have to be volatile, 
        because these variables can change at any time. Therefore, the compiler is not 
        going to make optimisations.
    -   Use boolean flags to send information between different processes.
    -   In the header file are extra functions and variables that can help you developing these procedures.
        You can add, change or remove these functions and variables at any time, as long as it is clear what you've done.
*/

/**
    This function is called when the button has been pressed by the user.
*/

Timeout timeout1;
Timeout timeout2;
DigitalOut busy_led(LED1);
volatile bool button1_pressed=false;   // Used in the main loop
volatile bool button1_enabled=true;   // Used for debouncing
volatile int multiclick_state=0;   // Counts how many clicks occured in the time slot, used in main loop
volatile int last_multiclick_state=0;   // Counts how many clicks occured in the previous timeslot
volatile bool button1_busy = false;      // Informs the mainloop that the user is clicking the button
volatile bool result_ready=false;

void button1_onpressed_cb(void)
{
    if(button1_enabled)
    {
        if(multiclick_state == 0) //first press this second
        {
            button1_busy=true;
            busy_led = 1;
            timeout1.attach(callback(&button1_multiclick_reset_cb), 1.0);           
        }
        multiclick_state += 1;
        button1_enabled=false;        
        timeout2.attach(callback(&button1_enabled_cb), 0.075);
    }
}

/**
    Resets the amount of clicks, but stores this value for the usage in the main loop
*/
void button1_multiclick_reset_cb()
{
    last_multiclick_state = multiclick_state;
    multiclick_state = 0;
    button1_busy=false;
    result_ready=true;
    busy_led=0;
}

/**
    Enables the button again after a timeout, used for debouncing the button 
*/
void button1_enabled_cb()
{
    button1_enabled=true;
}  