#include "slave.h"

#define MAX_BUFFER_SIZE 512
#define PORT 4000

Slave::Slave()
    :answer()
{
    //Constructor
}

void Slave::slaveRun(const char* ip, int identity)
{
    sprintf(id,"%ld",identity);
    EthernetInterface ethernet;
    ethernet.init(ip,"255.255.255.0", "192.168.0.1");
    ethernet.connect();
    
    //printf("Your ip is: %s", ethernet.getIPAddress());
    
    UDPSocket slave;
    slave.bind(PORT);
    Endpoint master;
    
    while(1){
        char buffer[MAX_BUFFER_SIZE] = {0};
        printf("##########################\n\r");
        printf("# Waiting for master.... #\n\r");
        printf("#    IP:%s    #\n\r", ip);
        printf("##########################\n\r\n");
        
        int n = slave.receiveFrom(master, buffer, sizeof(buffer));
        buffer[n] = '\0';
        
        printf("Received message from master with address: %s\n\r", master.get_address());
        printf("Received: '%s'\r\n", buffer);
        actionSlave(buffer);
        printf("Sending ACK: %s \n\r\n", answer);
        
        slave.sendTo(master, answer, MAX_BUFFER_SIZE);
        answerReset();
    }
}

void Slave::actionSlave(const char* fullbuffer){
    char* command = strtok((char*)fullbuffer, " ");
    char* action = strtok(NULL, " ");
    if(strcmp(command, "GET") == 0)
    {
        getRequest(action);
    }
    else 
    if(strcmp(command, "PUT") == 0)
    {
        putRequest(action);
    }
    else
    {
        answerAppend("ACK 4.0 ");
        answerAppend(id);
    }
}

void Slave::getRequest(char* action)
{
    char temp[8];
    if(strcmp(action, "/temperature") == 0)
    {
        sprintf(temp, "%.3f", temperature.getTemperature());
        answerAppend("ACK 2.05 ");
        answerAppend(id);
        answerAppend(" ");
        answerAppend(temp);
    }
    else 
    if(strcmp(action, "/potentiometer") == 0)
    {
        sprintf(temp, "%.0f", potentiometer.getPotentiometer()*255);
        answerAppend("ACK 2.05 ");
        answerAppend(id);
        answerAppend(" ");
        answerAppend(temp);
    }
    else
    {
       answerAppend("ACK 4.0 ");
       answerAppend(id);
    }
}

void Slave::putRequest(char* action)
{
    if(strcmp(action, "/LCD") == 0)
    {
        answerAppend("ACK 2.04 ");
        answerAppend(id);
        screen.lcdSlave(strtok(NULL, "\0"));
    }
    else 
    if(strcmp(action, "/LED") == 0)
    {
        if(led.setColor(strtok(NULL, " ")) == 0)
        {
            answerAppend("ACK 2.04 ");
            answerAppend(id);
        }
        else
        {
            answerAppend("ACK 4.0 ");
            answerAppend(id);
        }
        led.setColor(strtok(NULL, " "));
    }
    else
    if(strcmp(action, "/BUZZER") == 0)
    {
        int one = atoi(strtok(NULL, " -"));
        int two = atoi(strtok(NULL, " -"));
        if(one > 0 && one < 17 && two <18 && two > 0)
        {
            buzzer.playBuzzer(one,two);
            answerAppend("ACK 2.04 ");
            answerAppend(id);
        }
        else
        {
            answerAppend("ACK 4.0 ");
            answerAppend(id);
        }
    }
    else
    {
       answerAppend("ACK 4.0 ");
       answerAppend(id);
    }
}

void Slave::answerAppend(char* append)
{
    strcat(answer, append);
}

void Slave::answerReset(){
    for(int i = 0; i < 512; i++)
    {
        answer[i] = NULL;
    }
}