#include "setup.h"

BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
LcdControl lcd;

Setup::Setup()
    :tempID("100"), partOfIP("192.168.0.")
{
    //Constructor
}

int Setup::chooseID()
{
    int setID = 100;
    lcd.lcdReset();
    lcd.printID(setID);
    while(fire==0)
    {
        if(joy.read() == 1)
        {
            lcd.lcdReset();
            if(setID == 110){
                setID = 100;
            }
            else{
                setID++;
            }
            lcd.printID(setID);
            wait(0.3);
        }
        if(joy.read() == 2)
        {
            lcd.lcdReset();
            if(setID == 100){
                setID = 110;
            }
            else{
                setID--;
            }
            lcd.printID(setID);
            wait(0.3);
        }
    }    while(fire != 0){}
    return setID;
}

int Setup::chooseMode()
{
    lcd.printMode();
    lcd.printMasterSlave(mode);
    while(fire != 0){}
    while(fire == 0){
        if(joy.read() == 8) {
            if(mode == 1){
                mode=0;
                lcd.printMode();
                lcd.printMasterSlave(mode);
            }
        } 
        else 
        if(joy.read() == 4) {
            if(mode == 0){
                mode=1;
                lcd.printMode();
                lcd.printMasterSlave(mode);
            }
        }
    }
    lcd.lcdReset();
    lcd.printMasterSlave(mode);
    return mode;
}

char* Setup::convertToIP(int ID)
{
    sprintf(tempID,"%ld",ID);
    return strcat(partOfIP,tempID);
}