#include "master.h"

#define MAX_BUFFER_SIZE 512
#define PORT 4000

Serial pc(USBTX, USBRX);

Master::Master()
    :buffer(), receiveID()
{
    //Constructor
}

void Master::masterRun(const char* ip)
{
    EthernetInterface ethernet;
    ethernet.init(ip,"255.255.255.0", "192.168.0.1");
    ethernet.connect();
    
    //printf("Your ip is: %s \n\r", ethernet.getIPAddress());
    
    while(1)
    {
        printf("######################\n\r");
        printf("# ENTER YOUR COMMAND #\n\r");
        printf("#  IP:%s  #\n\r", ip);
        printf("######################\n\r\n");
        printf("Command: ");
        
        char buffer[MAX_BUFFER_SIZE] = {0};
        for(int i = 0; i < MAX_BUFFER_SIZE; i++){
            char temp = pc.getc();
            if(temp == 13){
                break;    
            }
            pc.putc(temp);
            buffer[i] = temp;
        }
        
        printf("\n\r\nEnter the ID you want to send your command: ");
        
        for(int i = 0; i < 4; i++){
            char temp = pc.getc();
            pc.putc(temp);
            receiveID[i] = temp;
        }
        char address[15] = "192.168.0.";
        strcat(address,receiveID);
        
        UDPSocket sock;
        sock.init();
        Endpoint slave;
        slave.set_address(address,PORT);
        
        sock.sendTo(slave, buffer, sizeof(buffer));
        
        char receive[MAX_BUFFER_SIZE] = {0};
        int n = sock.receiveFrom(slave, receive, sizeof(receive));
        receive[n]='\0';
    
        printf("\n\rReceived an answer from the slave!\n\r");
        printf("Answer: %s \n\r", receive);
        printf("------------------------------------------\r\n\n");
        
        sock.close();
    }
}