#ifndef lcdcontrol_h
#define lcdcontrol_h
#include "mbed.h"
#include "C12832A1Z.h"

class LcdControl
{
public:  
    LcdControl(); //Constructor
    
    /**
     * Deze methode zal voor de tekst layout zorgen als men de mode van de mbed moet kiezen.
     * Geen parameters nodig.
     */ 
    void printMode();
    
    /**
     * @param mode int
     *
     * Deze methode zal voor de tekst zorgen dat de gebruiker kan zien in welke mode hij zich bevindt.
     * Wordt uitsluitend gebruikt in de setup klasse.
     */ 
    void printMasterSlave(int);
    
    /**
     * @param ID int
     *
     * Deze methode zal de ID uitprinten op het lcd scherm.
     * Deze wordt opnieuw aangeroepen als men met de joystick up/down doet.
     * Deze methode wordt uitsluitend gebruikt in de setup klasse.
     */ 
    void printID(int);
    
    /**
     * Deze methode zal het lcd scherm resetten (dus clearen) en zijn cursor op de beginpositie 
     * plaatsen.
     * Deze methode heeft geen parameters nodig.
     */ 
    void lcdReset();
    
    /**
     * @param text char array
     *
     * Deze methode zal de tekst uitprinten dat je meegeeft met de methode. (parameter)
     * Wordt gebruikt in de slave.
     */ 
    void lcdSlave(char*);
};

#endif