#include "mbed.h"
#include "setup.h"
#include "lcdcontrol.h"
#include "master.h"
#include "slave.h"

int ID;
char *IP;
Setup setup;
Master master;
Slave slave;

int main() {
    printf("Use the joystick (up/down) to choose the mbed ID\n\r");
    printf("Push the joystick to confirm the ID\n\r");
    ID = setup.chooseID();
    printf("Your mbed has the id %d \n\r", ID);
    IP = setup.convertToIP(ID);
    printf("Follow the instructions on the lcd screen of the mbed to choose it's mode\n\r\n");
    if(setup.chooseMode() == 0)
    {
        slave.slaveRun(IP, ID);
    }
    else
    {
        master.masterRun(IP);
    }
}