#ifndef slave_h
#define slave_h
#include "EthernetInterface.h"
#include "mbed.h"
#include "temperature.h"
#include "potentiometer.h"
#include "lcdcontrol.h"
#include "led.h"
#include "buzzer.h"

class Slave
{
public:  
    Slave(); //Constructor
    
    /**
     * @param ip char array (const)
     * @param id int
     *
     * Deze methode is de Slave Run. Eenmaal in deze methode kan je er niet meer uit.
     * Je geeft het ip address mee, alsook het ID.
     * Deze methode zal eerst constant luisteren op het commando van de master mbed.
     * Wanneer deze methode iets binnenkrijgt, dan zal hij dit bericht verwerken aan de hand van andere methoden.
     * Als de slave het bericht heeft verwerkt, dan zal hij het juiste ACK bericht terugsturen naar de master.
     */ 
    void slaveRun(const char*, int);
    
    /**
     * @param fullbuffer char array
     *
     * Deze methode zal het volledig gekregen bericht opsplitsen in verschillende delen, om zo naar de juiste reactie te gaan.
     * In deze methode wordt er gecontroleerd ofdat er een GET of PUT wordt gevraagd.
     * Als er een GET of PUT wordt herkent, dan wordt de rest van het bericht doorgestuurd naar de juiste methode.
     * (getRequest, putRequest)
     */ 
    void actionSlave(const char*);
    
    /**
     * @param action char array
     * 
     * Deze methode zal de andere helft van het GET request behandelen.
     * Kan "/potentiometer" en "/temperature" correct behandelen (hoofdlettergevoelig).
     */ 
    void getRequest(char*);
    
    /**
     * @param action char array
     *
     * Deze methode zal de andere helft van het PUT request behandelen.
     * Kan "/LED", "/LCD" en "/buzzer" correct behandelen. (hoofdlettergevoelig)
     * Als er een fout argument meegegeven wordt met bovenstaande putrequests, dan wordt de
     * foutboodschap teruggestuurd naar de slave.
     */ 
    void putRequest(char*);
    
    /**
     * @param append char array
     *
     * Met deze methode kan je een character array toevoegen aan het antwoord van de slave.
     * De werking kan je vergelijken met een "string.append()".
     */ 
    void answerAppend(char*);
    
    /**
     * Deze methode zal het antwoord van de slave resetten, zodat hij een nieuw
     * antwoord kan vormen bij het volgende bericht.
     * Er worden geen parameters meegegeven bij deze methode.
     */ 
    void answerReset();
private:
    char answer [512];
    char id[4];
    const char* IP;
    Temperature temperature;
    Potentiometer potentiometer;
    LcdControl screen;
    Led led;
    Buzzer buzzer;
};

#endif