#ifndef setup_h
#define setup_h
#include "mbed.h"
#include "lcdcontrol.h"

class Setup
{
public:  
    Setup(); //Constructor
    
    /**
     * Deze methode zal de mode instellen voor de mbed
     * Je kan alleen uit deze methode als je de joystick indrukt.
     * Geen parameters nodig.
     * Zal een int waarde returnen, die zal vertellen in welke mode je zit.
     * (0 = slave, 1= master)
     */ 
    int chooseMode();
    
    /**
     * Deze methode zal je ID kunnen selecteren van de mbed.
     * Je kan alleen uit deze methode als je de joystick indrukt.
     * Met up/down kan je je ID kiezen tussen 100 en 110.
     * Geen parameters nodig.
     * Zal de gekozen ID als een int waarde returnen.
     */ 
    int chooseID(); 
    
    /**
     * @param ID int
     *
     * Deze methode zal van je ID, bestaande uit 3 cijfers, vastplakken aan de standaard IP address.
     * ("192.168.0." + ID)
     * Deze methode zal dan een character array returnen met het volledig IP address van de mbed.
     */ 
    char* convertToIP(int);
private:
    int mode;
    char *ip;
    char tempID[4];
    char partOfIP[15];
};

#endif