/*
 * Copyright (C)2010-2012 Henning Karlsen. All right reserved.
 * Copyright (C)2012 Todor Todorov.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to:
 *
 * Free Software Foundation, Inc.
 * 51 Franklin St, 5th Floor, Boston, MA 02110-1301, USA
 *
 *********************************************************************/
#include "hx8352a.h"
#include "helpers.h"

HX8352A_LCD::HX8352A_LCD( PinName CS, PinName RESET, PinName RS, PinName WR, BusOut* DATA_PORT, PinName BL, PinName RD, backlight_t blType, float defaultBackLightLevel )
    : LCD( 240, 400, CS, RS, RESET, BL, blType, defaultBackLightLevel ), _lcd_pin_wr( WR )
{
    _lcd_port = DATA_PORT;
    if ( RD != NC ) _lcd_pin_rd = new DigitalOut( RD );
    else _lcd_pin_rd = 0;
}

void HX8352A_LCD::Initialize( orientation_t orientation, colordepth_t colors )
{
    _orientation = orientation;
    _colorDepth = colors;
    
    wait_ms( 100 );
    _lcd_pin_reset = HIGH;
    wait_ms( 50 );
    _lcd_pin_reset = LOW;
    wait_ms( 50 );
    _lcd_pin_reset = HIGH;
    _lcd_pin_cs = HIGH;
    //_lcd_pin_rd = HIGH;
     if ( _lcd_pin_bl != 0 )
        *_lcd_pin_bl = HIGH;
    else if ( _bl_pwm != 0 )
        *_bl_pwm = _bl_pwm_default;
    _lcd_pin_wr = HIGH;
    wait_ms( 55 );
    
    Activate();
    Activate();
    WriteCmdData( 0x83, 0x0002 );   //TESTM=1 
    
    WriteCmdData( 0x85, 0x0003 );  //VDC_SEL=011
    WriteCmdData( 0x8B, 0x0001 );
    WriteCmdData( 0x8C, 0x0093 ); //STBA[7]=1,STBA[5:4]=01,STBA[1:0]=11
    
    WriteCmdData( 0x91, 0x0001 ); //DCDC_SYNC=1
    
    WriteCmdData( 0x83, 0x0000 );
    //WriteCmdData( 0x00, 0x0001 ); //TESTM=0
    
    //Gamma Setting   
    WriteCmdData( 0x3E, 0x00B0);
    WriteCmdData( 0x3F, 0x0003 );
    WriteCmdData( 0x40, 0x0010 );
    WriteCmdData( 0x41, 0x0056 );
    WriteCmdData( 0x42, 0x0013 );
    WriteCmdData( 0x43, 0x0046 );
    WriteCmdData( 0x44, 0x0023 );
    WriteCmdData( 0x45, 0x0076 );
    WriteCmdData( 0x46, 0x0000 );
    WriteCmdData( 0x47, 0x005E );
    WriteCmdData( 0x48, 0x004F );
    WriteCmdData( 0x49, 0x0040 );

    //**********Power On sequence************
    WriteCmdData( 0x17, 0x0091 );
    
    WriteCmdData( 0x2B, 0x00F9 );
    wait_ms( 15 );
    
    WriteCmdData( 0x1B, 0x0014 );
    
    WriteCmdData( 0x1A, 0x0011 );
    
    WriteCmdData( 0x1C, 0x0006 );
    
    WriteCmdData( 0x1F, 0x0042 );
    wait_ms( 20 );
    
    WriteCmdData( 0x19, 0x000A );
    
    WriteCmdData( 0x19, 0x001A );
    wait_ms( 40 );
    
    WriteCmdData( 0x19, 0x0012 );
    wait_ms( 40 );
    
    WriteCmdData( 0x1E, 0x0027 );
    wait_ms( 100 );
    
    //**********DISPLAY ON SETTING***********

    WriteCmdData( 0x24, 0x0060 );

    WriteCmdData( 0x3D, 0x0040 );

    WriteCmdData( 0x34, 0x0038 );

    WriteCmdData( 0x35, 0x0038 );

    WriteCmdData( 0x24, 0x0038 );
    wait_ms( 40 );

    WriteCmdData( 0x24, 0x003C );

    //WriteCmdData( 0x16, 0x00B8 );

    WriteCmdData( 0x01, 0x0006 );

    WriteCmdData( 0x55, 0x0000 );

    WriteCmdData( 0x02, 0x0000 );
    WriteCmdData( 0x03, 0x0000 );
    WriteCmdData( 0x04, 0x0000 );
    WriteCmdData( 0x05, 0x00EF );

    WriteCmdData( 0x06, 0x0000 );
    WriteCmdData( 0x07, 0x0000 );
    WriteCmdData( 0x08, 0x0001 );
    WriteCmdData( 0x09, 0x008F );
    
    
    WriteCmd( 0x16 );
    switch ( _orientation )
    {
        case LANDSCAPE: WriteData( 0xA8 ); break;
        case PORTRAIT_REV: WriteData( 0xDC ); break;
        case LANDSCAPE_REV: WriteData( 0x6C ); break;
        case PORTRAIT:
        default: WriteData( 0x08 ); break;
    }
    
    WriteCmd( 0x22 );
    wait_ms( 10 );
    
    ClearXY();
    Deactivate();
}

/*
void HX8352A_LCD::Sleep( void )
{
    Activate();
    WriteCmd( 0x28 );
    wait_ms( 10 );
    WriteCmd( 0x10 );
    wait_ms( 125 );
    LCD::Sleep();
    Deactivate();
}

void HX8352A_LCD::WakeUp( void )
{
    Activate();
    WriteCmd( 0x29 );
    wait_ms( 10 );
    WriteCmd( 0x11 );
    wait_ms( 125 );
    LCD::WakeUp();
    Deactivate();
}
*/

void HX8352A_LCD::WriteCmd( unsigned short cmd )
{
    _lcd_pin_rs = LOW;
    _lcd_port->write( cmd );
    pulseLow( _lcd_pin_wr );}

void HX8352A_LCD::WriteData( unsigned short data )
{
    _lcd_pin_rs = HIGH;
    _lcd_port->write( data );
    pulseLow( _lcd_pin_wr );
}

void HX8352A_LCD::SetXY( unsigned short x1, unsigned short y1, unsigned short x2, unsigned short y2 )
{
    switch ( _orientation ) {
        case LANDSCAPE:
        case LANDSCAPE_REV:
            WriteCmdData( 0x02,x1>>8 );
            WriteCmdData( 0x03,x1 );
            WriteCmdData( 0x04,x2>>8 );
            WriteCmdData( 0x05,x2 );
            WriteCmdData( 0x06,y1>>8 );
            WriteCmdData( 0x07,y1 );
            WriteCmdData( 0x08,y2>>8 );
            WriteCmdData( 0x09,y2 );
            break;
            
        case PORTRAIT_REV:
        case PORTRAIT:
        default:
            WriteCmdData( 0x02,x1>>8 );
            WriteCmdData( 0x03,x1 );
            WriteCmdData( 0x04,x2>>8 );
            WriteCmdData( 0x05,x2 );
            WriteCmdData( 0x06,y1>>8 );
            WriteCmdData( 0x07,y1 );
            WriteCmdData( 0x08,y2>>8 );
            WriteCmdData( 0x09,y2 );
            break;
    }
    WriteCmd( 0x22 ); // RAMWR
}

void HX8352A_LCD::SetPixelColor( unsigned int color, colordepth_t mode )
{
    unsigned char r = 0, g = 0, b = 0;
    unsigned short clr;
    if ( _colorDepth == RGB16 )
    {
        switch ( mode )
        {
            case RGB16:
                WriteData( color & 0xFFFF );
                break;
            case RGB18:
                r = ( color >> 10 ) & 0xF8;
                g = ( color >> 4 ) & 0xFC;
                b = ( color >> 1 ) & 0x1F;
                clr = ( ( r | ( g >> 5 ) ) << 8 ) | ( ( g << 3 ) | b );
                WriteData( clr );
                break;
            case RGB24:
                r = ( color >> 16 ) & 0xF8;
                g = ( color >> 8 ) & 0xFC;
                b = color & 0xF8;
                clr = ( ( r | ( g >> 5 ) ) << 8 ) | ( ( g << 3 ) | ( b >> 3 ) );
                WriteData( clr );
                break;
        }
    }
    else if ( _colorDepth == RGB18 )
    {
        switch ( mode )
        {
            case RGB16:
                r = ( ( color >> 8 ) & 0xF8 ) | ( ( color & 0x8000 ) >> 13 );
                g = ( color >> 3 ) & 0xFC;
                b = ( ( color << 3 ) & 0xFC ) | ( ( color >> 3 ) & 0x01 );
                break;
            case RGB18:
                b = ( color << 2 ) & 0xFC;
                g = ( color >> 4 ) & 0xFC;
                r = ( color >> 10 ) & 0xFC;
                break;
            case RGB24:
                r = ( color >> 16 ) & 0xFC;
                g = ( color >> 8 ) & 0xFC;
                b = color & 0xFC;
                break;
        }
        WriteData( r );
        WriteData( g );
        WriteData( b );
    }
}

