#include "mbed.h"

AnalogIn base_voltage(p15);
AnalogIn coll_voltage(p16);

int base_resistor, coll_resistor;
float base_current, adj_base_voltage;
float coll_current, adj_coll_voltage, beta;

int main() {

printf ("Please enter a base resistor value\n");
scanf ("%i", &base_resistor);

printf("Please enter a collector resistor value\n");
scanf ("%i", &coll_resistor);

//calculate base current
adj_base_voltage = (1 - base_voltage) * 3.3;   //voltage across base resistor
base_current = adj_base_voltage/base_resistor;

//calculate collector current
adj_coll_voltage = (1.515 - coll_voltage) * 3.3;  //1.515 is 5V as 1 is 3.3V
coll_current = adj_coll_voltage/coll_resistor;

//calculate current gain
beta = coll_current / base_current;
printf ("Transistor beta is %f\n", beta);
printf ("The voltage across Rb is %f\n", adj_base_voltage);
printf ("The voltage across Rc is %f\n", adj_coll_voltage);

}









