#include "mbed.h"

Thread ISRthread(osPriorityAboveNormal);
osThreadId ISRthreadId;

RawSerial pc(USBTX, USBRX);

DigitalOut myled(LED1);
DigitalOut myled4(LED4);

void newInput();
void ISR_thread();

int main() {
    
   ISRthread.start(callback(ISR_thread));
   pc.attach(&newInput);                                      //interrupt to catch input
   
    while(1) {
        myled4 = 1;
    }
}


void newInput() {
    pc.attach(NULL);                                           //deatch the ISR to prevent recursive calls
    osSignalSet(ISRthreadId,0x01);
}


void ISR_thread() {
    ISRthreadId = osThreadGetId();
    for(;;) {
        osSignalWait(0x01, osWaitForever);
        
        while (pc.readable()) {
            pc.putc(pc.getc());
        }
        myled = 1;
        osDelay(50);
        myled = 0;
        pc.attach(&newInput);                                     //re-attach the ISR
    }
}