#include "mbed.h"

InterruptIn button(p14);

Thread ISRthread(osPriorityAboveNormal);
osThreadId ISRthreadId;

DigitalOut myled(LED1);
DigitalOut myled3(LED3);

void newInput();
void ISR_thread();

int main() {
    
   ISRthread.start(callback(ISR_thread));
   button.rise(&newInput);          //interrupt to catch input
   
    while(1) {
        myled = 1;
        osDelay(1000);
        myled = 0;
        osDelay(1000);
    }
}


void newInput() {
    osSignalSet(ISRthreadId,0x01);
}


void ISR_thread() {
    ISRthreadId = osThreadGetId();
    for(;;) {
        osSignalWait(0x01, osWaitForever);
        myled3 = 1;
        osDelay(500);
        myled3 = 0;
    }
}