/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech
 
Description: LoRaMac classA device implementation
 
License: Revised BSD License, see LICENSE.TXT file include in the project
 
Maintainer: Miguel Luis and Gregory Cristian
*/
#include "mbed.h"
#include "board.h"
#include "radio.h"
#include "LoRaMac.h"
 
 
#define APPDATA_SIZE 45
#define LORAWAN_DEFAULT_DATARATE DR_0
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x01234567
#define LORAWAN_NWKSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }
#define LORAWAN_APPSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }
 
uint8_t AppData[APPDATA_SIZE];
static uint8_t NwkSKey[] = LORAWAN_NWKSKEY;
static uint8_t AppSKey[] = LORAWAN_APPSKEY;
 

#include "mbed.h"
#include "l86.hpp"


// #ifdef DEBUGGER
RawSerial pc(USBTX, USBRX);    // USART2
// #endif

RawSerial gps(GPS_TX, GPS_RX); // USART1

// DigitalOut Reset(RESET_PIN);
// DigitalOut Force_on(FORCE_ON_PIN);
DigitalOut GPS_status(GPS_STATUS_LED);
// DigitalIn  OnePPS(ONEPPS_PIN);

RMC_data RMC;
GPS_data GPS_parse;
volatile int Char_index = 0;                  // index for char array
char Rx_data[MAX_NMEA_LENGTH] = "0";          // char array to store received bytes
// uint8_t valid = 0;
//volatile uint8_t GPS_data_ready = 0;
volatile uint8_t sending = 0;

volatile bool timerset = false;

volatile bool firstfix = false;

volatile bool keepOut = false; 

Ticker LoRaSend_timer;

//void flushSerialBuffer(void) { char char1 = 0; while (gps.readable()) { char1 = gps.getc(); } return; }

void LoRaSend(){
    //GPS_status = !GPS_status;
    //if (keepOut)
    //    return;
    __disable_irq();//NVIC_DisableIRQ(USART1_IRQn);
    //if(GPS_data_ready == 1){
        // pc.putc('1');
        sending = 1;
        // pc.putc('3');
        char AppDatas[APPDATA_SIZE];
        // pc.putc('4');
        strcpy(AppDatas, GPS_parse.Latitude); 
        // pc.putc('5');
        strcat(AppDatas, ",");
        // pc.putc('6');
        strcat(AppDatas, GPS_parse.Longitude);
        // pc.putc('7');
        strcat(AppDatas, ",");
        // pc.putc('8');
        strcat(AppDatas, GPS_parse.Course_Over_Ground);
        // pc.putc('9'); 
        strcat(AppDatas, ",");
        // pc.putc('a');
        strcat(AppDatas, GPS_parse.Speed_Over_Ground);
        // pc.putc('b');
        strcat(AppDatas, ",");
        //strcat(AppDatas, GPS_parse.Date);
        //strcat(AppDatas, ",");
        // pc.putc('c');
        strcat(AppDatas, GPS_parse.UTC_Time);
        // pc.putc('d');
        strcat(AppDatas, ",");
        // pc.putc('e');
        strcat(AppDatas, GPS_parse.Valid);
        // pc.putc('f');
        // McpsReq_t mcpsReq;
        // pc.putc('g');
        // uint8_t AppPort = 3;
        // pc.putc('h');
        //  mcpsReq.Type = MCPS_UNCONFIRMED;
        // pc.putc('i');
        // mcpsReq.Req.Unconfirmed.fPort = AppPort;
        // pc.putc('j');
        // mcpsReq.Req.Unconfirmed.fBuffer = AppDatas;
        // pc.putc('k');
        // mcpsReq.Req.Unconfirmed.fBufferSize = APPDATA_SIZE+2;
        // pc.putc('l');
        // mcpsReq.Req.Unconfirmed.Datarate = DR_5;
        // status = !status;
        //GPS_status = !GPS_status;
        // pc.putc('m');
        // LoRaMacMcpsRequest( &mcpsReq );
        // GPS_data_ready = 0;
        // Ready_for_more = 1;
    //}
    sending = 0;
    __enable_irq();//NVIC_EnableIRQ(USART1_IRQn);
    pc.putc('N');
}


void gps_receive(void) {
    // Note: you need to actually read from the serial to clear the RX interrupt
    __disable_irq();
    keepOut = true;     //
    while(gps.readable()) {
        char incoming = gps.getc();
        // #ifdef DEBUGGER
        // pc.putc(incoming);
        // #endif
        Rx_data[Char_index] = incoming;
    
        if((Rx_data[Char_index] == '\n')){    // Received the end of an NMEA scentence
            if((strncmp(GPRMC_Tag,Rx_data,(sizeof(GPRMC_Tag)-1)) == 0) || (strncmp(GNRMC_Tag,Rx_data,(sizeof(GNRMC_Tag)-1)) == 0)){
                RMC = Parse_RMC_sentence(Rx_data);
                if(strcmp(RMC.Status, "A") == 0){
                    // valid = 1;
                    // GPS_status = 0;    // Turn status LED off
                    // GPS_parse = Parse_RMC_data(RMC); // Parse into format suitable for Tom (Dinghy_RaceTrak software)
                    // Call function to send using LoRa module
                    // LoRaSend();
                    // pc.putc('O');
                    if(timerset == false)
                        firstfix = true;
                    /*
                    if(firstfix == false)                       //
                    {                                           //
                        //LoRaSend_timer.attach(&LoRaSend, 1.0);  //
                        firstfix = true;                        //                
                    }   */                                   //                
                }
                else{
                    // GPS_status = 1;
                    // Send "No GPS fix" over LoRa?
                }
                ///*
                if (sending)                            //
                {                                       // 
                    Char_index = 0;                     //
                    memset(Rx_data,0,sizeof(Rx_data));  //
                    __enable_irq();                     //
                    keepOut = false;                    //
                    return;                             //
                }   //*/                                //
                GPS_status=!GPS_status;
                // delete this line
                //GPS_data_ready = 0;
                GPS_parse = Parse_RMC_data(RMC); // Parse into format suitable for Tom (Dinghy_RaceTrak software)
                //GPS_data_ready = 1;


            }
            Char_index = 0;
            memset(Rx_data,0,sizeof(Rx_data));
        }
        else
            Char_index++;
    }
    keepOut = false;
    __enable_irq();
    // put first fix code here if above doesn't work
    return;
    // store chars into a string then process into LAT, LONG, SOG, COG & DATETIME, VALID/INVLAID
}

void McpsConfirm( McpsConfirm_t *mcpsConfirm )
{
    return;
}
 
void McpsIndication( McpsIndication_t *mcpsIndication )
{
    return;
}
 
 
int main( void )
{
    //Initialise firmware
        
    LoRaMacPrimitives_t LoRaMacPrimitives;
    LoRaMacCallback_t LoRaMacCallbacks;
    MibRequestConfirm_t mibReq;
 
    LoRaMacPrimitives.MacMcpsConfirm = McpsConfirm;
    LoRaMacPrimitives.MacMcpsIndication = McpsIndication;
//    LoRaMacPrimitives.MacMlmeConfirm = McpsConfirm;
    LoRaMacInitialization( &LoRaMacPrimitives, &LoRaMacCallbacks );
 
    LoRaMacChannelAdd( 3, ( ChannelParams_t ){ 868100000, { ( ( DR_5 << 4 ) | DR_5 ) }, 3 } );
    //LoRaMacChannelAdd( 4, ( ChannelParams_t ){ 867300000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 5, ( ChannelParams_t ){ 867500000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 6, ( ChannelParams_t ){ 867700000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 7, ( ChannelParams_t ){ 867900000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 8, ( ChannelParams_t ){ 868800000, { ( ( DR_7 << 4 ) | DR_7 ) }, 2 } );
    //LoRaMacChannelAdd( 9, ( ChannelParams_t ){ 868300000, { ( ( DR_6 << 4 ) | DR_6 ) }, 1 } );
 
    //Join ABP
 
    mibReq.Type = MIB_NET_ID;
    mibReq.Param.NetID = 0;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_DEV_ADDR;
    mibReq.Param.DevAddr = LORAWAN_DEVICE_ADDRESS;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_NWK_SKEY;
    mibReq.Param.NwkSKey = NwkSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_APP_SKEY;
    mibReq.Param.AppSKey = AppSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_NETWORK_JOINED;
    mibReq.Param.IsNetworkJoined = true;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_TX_POWER;
    mibReq.Param.ChannelsTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_DEFAULT_TX_POWER;
    mibReq.Param.ChannelsDefaultTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    /*//Prepareframe
 
    AppData[0] = 0x43;
    AppData[1] = 0x68;
    AppData[2] = 0x72;
    AppData[3] = 0x69;
    AppData[4] = 0x73;
    AppData[5] = 0x21;
    AppData[6] = 0x21;
    
    //Sendframe
    
    McpsReq_t mcpsReq;
     
    uint8_t AppPort = 3;
    mcpsReq.Type = MCPS_UNCONFIRMED;
    mcpsReq.Req.Unconfirmed.fPort = AppPort;
    mcpsReq.Req.Unconfirmed.fBuffer = AppData;
    mcpsReq.Req.Unconfirmed.fBufferSize = APPDATA_SIZE;
    mcpsReq.Req.Unconfirmed.Datarate = DR_5;
        
    LoRaMacMcpsRequest( &mcpsReq );*/
    GPS_status = 1;
    gps.attach(&gps_receive, Serial::RxIrq);
    gps.printf(PMTK_SET_NMEA_OUTPUT_RMC); // Only output RMC and GPTXT
    wait(1.0); 
    gps.printf(PMTK_SET_UPDATE_F_2HZ);    // Set update Frequency to 2Hz
    wait(1.0); 
    gps.printf(PMTK_SET_NMEA_OUTPUT_RMC); // Only output RMC and GPTXT
    wait(1.0); 
    gps.printf(PMTK_SET_UPDATE_F_2HZ);    // Set update Frequency to 2Hz
    wait(1.0); 
    gps.printf(PMTK_SET_NMEA_OUTPUT_RMC); // Only output RMC and GPTXT
    wait(1.0); 
    gps.printf(PMTK_SET_UPDATE_F_2HZ);    // Set update Frequency to 2Hz
    //LoRaSend_timer.attach(&LoRaSend, 1.0);
    while(1){
        if(sending==0){
            Print_GPS_data(GPS_parse);
        }
        if(firstfix){
            LoRaSend_timer.attach(&LoRaSend, 1.0);
            firstfix = false;
            timerset = true;
        }
        wait(0.5);
        }
}