/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: LoRaMac classA device implementation

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#include "mbed.h"
#include "board.h"
#include "radio.h"
#include "LoRaMac.h"
#include "l86.hpp"


// #define APPDATA_SIZE 55 // size of a GPS_data struct //commented by Rish
#define LORAWAN_DEFAULT_DATARATE DR_0
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x01234567
#define LORAWAN_NWKSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }
#define LORAWAN_APPSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }


RawSerial gps(GPS_TX, GPS_RX); // USART1
// RawSerial pc(PC_TX, PC_RX);

DigitalOut Reset(RESET_PIN);
DigitalOut Force_on(FORCE_ON_PIN);
DigitalOut GPS_status(GPS_STATUS_LED);
// DigitalIn  OnePPS(ONEPPS_PIN);


// uint8_t AppDatasend[APPDATA_SIZE];
RMC_data RMC;
GPS_data GPS_parse;
volatile int Char_index = 0;                  // index for char array
char Rx_data[MAX_NMEA_LENGTH] = "0";          // char array to store received bytes
char tx_line[82];
volatile uint8_t Transmission_in_progress = 0;

void gps_receive(void) {
    // Note: you need to actually read from the serial to clear the RX interrupt
    while(gps.readable()) {
        char incoming = gps.getc();
        // #ifdef DEBUGGER
        // pc.putc(incoming);
        // #endif
        Rx_data[Char_index] = incoming;
        if(Rx_data[Char_index] == '$'){
            Transmission_in_progress = 1;
        }
        if(Transmission_in_progress == 1){
            if((Rx_data[Char_index] == '\n')){    // Received the end of an NMEA scentence
                if((strncmp(GPRMC_Tag,Rx_data,(sizeof(GPRMC_Tag)-1)) == 0) || (strncmp(GNRMC_Tag,Rx_data,(sizeof(GNRMC_Tag)-1)) == 0)){
                    RMC = Parse_RMC_sentence(Rx_data);
                    if(strcmp(RMC.Status, "A") == 0){
                        GPS_status = 0;    // Turn status LED off
                    }
                    else{
                        //GPS_status = 1;
                    }
                    GPS_status = !GPS_status; // for debugging
                    NVIC_DisableIRQ(USART1_IRQn);
                    GPS_parse = Parse_RMC_data(RMC); // Parse into format suitable for Tom (Dinghy_RaceTrak software)
                    // Send_GPS_data(GPS_parse); // This doesn't work with LoRa send code but works without :/
                    NVIC_EnableIRQ(USART1_IRQn);
                }
                Transmission_in_progress = 0;
                Char_index = 0;
                memset(Rx_data,0,sizeof(Rx_data));
            }
            else
                Char_index++;
        }
    }
    return;
    // store chars into a string then process into LAT, LONG, SOG, COG & DATETIME, VALID/INVLAID
}

static uint8_t NwkSKey[] = LORAWAN_NWKSKEY;
static uint8_t AppSKey[] = LORAWAN_APPSKEY;



void McpsConfirm( McpsConfirm_t *mcpsConfirm )
{
    return;
}

void McpsIndication( McpsIndication_t *mcpsIndication )
{
    return;
}



 
int main( void )
{
    //Initialise firmware
       
    LoRaMacPrimitives_t LoRaMacPrimitives;
    LoRaMacCallback_t LoRaMacCallbacks;
    MibRequestConfirm_t mibReq;

    LoRaMacPrimitives.MacMcpsConfirm = McpsConfirm;
    LoRaMacPrimitives.MacMcpsIndication = McpsIndication;
//    LoRaMacPrimitives.MacMlmeConfirm = McpsConfirm;
    LoRaMacInitialization( &LoRaMacPrimitives, &LoRaMacCallbacks );

    LoRaMacChannelAdd( 3, ( ChannelParams_t ){ 869400000, { ( ( DR_5 << 4 ) | DR_5 ) }, 3 } );
    //LoRaMacChannelAdd( 4, ( ChannelParams_t ){ 867300000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 5, ( ChannelParams_t ){ 867500000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 6, ( ChannelParams_t ){ 867700000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 7, ( ChannelParams_t ){ 867900000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 8, ( ChannelParams_t ){ 868800000, { ( ( DR_7 << 4 ) | DR_7 ) }, 2 } );
    //LoRaMacChannelAdd( 9, ( ChannelParams_t ){ 868300000, { ( ( DR_6 << 4 ) | DR_6 ) }, 1 } );

    //Join ABP

    mibReq.Type = MIB_NET_ID;
    mibReq.Param.NetID = 0;
    LoRaMacMibSetRequestConfirm( &mibReq );

    mibReq.Type = MIB_DEV_ADDR;
    mibReq.Param.DevAddr = LORAWAN_DEVICE_ADDRESS;
    LoRaMacMibSetRequestConfirm( &mibReq );

    mibReq.Type = MIB_NWK_SKEY;
    mibReq.Param.NwkSKey = NwkSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );

    mibReq.Type = MIB_APP_SKEY;
    mibReq.Param.AppSKey = AppSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );

    mibReq.Type = MIB_NETWORK_JOINED;
    mibReq.Param.IsNetworkJoined = true;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_TX_POWER;
    mibReq.Param.ChannelsTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_DEFAULT_TX_POWER;
    mibReq.Param.ChannelsDefaultTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );

    /*//Prepareframe

    AppData[0] = 0x43;
    AppData[1] = 0x68;
    AppData[2] = 0x72;
    AppData[3] = 0x69;
    AppData[4] = 0x73;
    AppData[5] = 0x21;
    AppData[6] = 0x21;*/
    
    //Sendframe
    
    /*McpsReq_t mcpsReq; // Commented out by Rish
    
    uint8_t AppPort = 3;
    mcpsReq.Type = MCPS_UNCONFIRMED;
    mcpsReq.Req.Unconfirmed.fPort = AppPort;
    mcpsReq.Req.Unconfirmed.fBuffer = AppData;
    mcpsReq.Req.Unconfirmed.fBufferSize = APPDATA_SIZE;
    mcpsReq.Req.Unconfirmed.Datarate = DR_5;
        
    //LoRaMacMcpsRequest( &mcpsReq );*/ // Commented out by Rish
    
    GPS_status = 1;
    gps.attach(&gps_receive, Serial::RxIrq);
    gps.printf(PMTK_SET_NMEA_OUTPUT_RMC); // Only output RMC and GPTXT
    gps.printf(PMTK_SET_UPDATE_F_2HZ);    // Set update Frequency to 2Hz 
    
    while(1){
        wait(3);
        //LoRaMacMcpsRequest( &mcpsReq );
        // Print_GPS_data(GPS_parse);
        while(Transmission_in_progress==1);
        NVIC_DisableIRQ(USART1_IRQn);
        Send_GPS_data(GPS_parse);
        NVIC_EnableIRQ(USART1_IRQn);
        }
}

