#include "l86.hpp"
#include <string.h>
#include <stdio.h>
#include "mbed.h"
#include "LoRaMac.h"
#include "board.h"
#include "radio.h"

#ifdef DEBUGGER
RawSerial pc2(PC_TX, PC_RX);    // USART2
#endif

/* Parse NMEA RMC sentence into RMC data struct */
RMC_data Parse_RMC_sentence(char RMC_sentence[MAX_NMEA_LENGTH]){
    const char delimeter[2] = ",";
    char *token = "";
    int i = 0;
    char temp[11][12];          /* [11][12]: 11 strings, of length 12 */
    RMC_data RMC_parsed;
    
    strcpy(RMC_parsed.Message, RMC_sentence);
    
    //Seperated Message
    /* get the first token */
   token = strtok(RMC_sentence, delimeter);
   
   /* walk through other tokens */
   while( token != NULL ) 
   {
         strcpy(temp[i],token);
         i++;
     token = strtok(NULL, delimeter);
   }
     
    //Copy the message into its individual components
    strcpy(RMC_parsed.Message_ID,temp[0]);
    strcpy(RMC_parsed.UTC_Time,temp[1]);
    strcpy(RMC_parsed.Status,temp[2]);
    if(strcmp(RMC_parsed.Status,"A") == 0){
        strcpy(RMC_parsed.Latitude,temp[3]);
        strcpy(RMC_parsed.N_S_Indicator,temp[4]);
        strcpy(RMC_parsed.Longitude,temp[5]);
        strcpy(RMC_parsed.E_W_Indicator,temp[6]);
        strcpy(RMC_parsed.Speed_Over_Ground,temp[7]);
        strcpy(RMC_parsed.Course_Over_Ground,temp[8]);
        strcpy(RMC_parsed.Date,temp[9]);
        strcpy(RMC_parsed.Mode,temp[10]);
    }
    return RMC_parsed;
}

// Use GPS data parse function? // parses into data formats that will be sent over LoRa

/* Print RMC_data struct to PC USART for debugging */
void Print_RMC_data(RMC_data *RMC_data_print){
    pc2.printf("RMC_Message: %s",RMC_data_print->Message);
    pc2.printf("UTC_Time: %s\r\n",RMC_data_print->UTC_Time);
    pc2.printf("Status: %s\r\n",RMC_data_print->Status);
    if(strcmp(RMC_data_print->Status,"A") == 0){
        pc2.printf("Latitude: %s\r\n",RMC_data_print->Latitude);
        pc2.printf("N/S: %s\r\n",RMC_data_print->N_S_Indicator);
        pc2.printf("Longitude: %s\r\n",RMC_data_print->Longitude);
        pc2.printf("E/W: %s\r\n",RMC_data_print->E_W_Indicator);
        pc2.printf("Speed: %s\r\n",RMC_data_print->Speed_Over_Ground);
        pc2.printf("Course: %s\r\n",RMC_data_print->Course_Over_Ground);
        pc2.printf("Date: %s\r\n",RMC_data_print->Date);
        pc2.printf("Mode: %s\r\n",RMC_data_print->Mode);
    }
}

/* Parse RMC_data struct into GPS data struct ready for sending over LoRa */
GPS_data Parse_RMC_data(RMC_data RMC_parsed){
    GPS_data GPS_parsed;
    if(strcmp(RMC_parsed.Status,"A") == 0){
        strcpy(GPS_parsed.UTC_Time,RMC_parsed.UTC_Time);
        if (strcmp(RMC_parsed.N_S_Indicator, "N") == 0){
            strcpy(GPS_parsed.Latitude, strcat("+", RMC_parsed.Latitude));
        }
        else{
            strcpy(GPS_parsed.Latitude, strcat("-", RMC_parsed.Latitude));
        }
        if (strcmp(RMC_parsed.E_W_Indicator, "E") == 0){
            strcpy(GPS_parsed.Longitude, strcat("+", RMC_parsed.Longitude));
        }
        else{
            strcpy(GPS_parsed.Longitude, strcat("-", RMC_parsed.Longitude));
        }
        strcpy(GPS_parsed.Speed_Over_Ground,RMC_parsed.Speed_Over_Ground);
        strcpy(GPS_parsed.Course_Over_Ground,RMC_parsed.Course_Over_Ground);
        strcpy(GPS_parsed.Date,RMC_parsed.Date);
        strcpy(GPS_parsed.Valid,RMC_parsed.Status);
    }
    else {
        strcpy(GPS_parsed.UTC_Time, "000000.000");
        strcpy(GPS_parsed.Latitude,"+0000.0000");
        strcpy(GPS_parsed.Longitude,"+00000.0000");
        strcpy(GPS_parsed.Speed_Over_Ground,"0.00");
        strcpy(GPS_parsed.Course_Over_Ground,"000.00");
        strcpy(GPS_parsed.Date,"000000");
        strcpy(GPS_parsed.Valid,RMC_parsed.Status);
    }
    return GPS_parsed;
}

/* Print GPS_data struct to PC USART for debugging */
void Print_GPS_data(GPS_data GPS_data_print){
    pc2.printf("UTC_Time: %s\r\n",GPS_data_print.UTC_Time);
    pc2.printf("Status: %s\r\n",GPS_data_print.Valid);
    pc2.printf("Latitude: %s\r\n",GPS_data_print.Latitude);
    pc2.printf("Longitude: %s\r\n",GPS_data_print.Longitude);
    pc2.printf("Speed: %s\r\n",GPS_data_print.Speed_Over_Ground);
    pc2.printf("Course: %s\r\n",GPS_data_print.Course_Over_Ground);
    pc2.printf("Date: %s\r\n",GPS_data_print.Date);
}

/* Send GPS data using LoRa module */
void Send_GPS_data(GPS_data GPS_data_parsed, McpsReq_t *mcpsReqs){//, char *NodeID, char Boat_type){
    char AppData[APPDATA_SIZE];
    
    // Could do this using a pointer and pointing to the address of the struct?
    // fill AppData byte array with GPS_data struct
    // strcat(AppData, NodeID);
    // strcat(AppData, ",");
    // strcat(AppData, Boat_type);
    // strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Latitude);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Longitude);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Course_Over_Ground);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Speed_Over_Ground);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Date);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.UTC_Time);
    strcat(AppData, ",");
    strcat(AppData, GPS_data_parsed.Valid);
    
    //Sendframe
            
    // LoRaMacMcpsRequest( &mcpsReq );
    //memset(&AppData[0], 0, sizeof(AppData));
}
