#include "mbed_events.h"
#include "mbed.h"
#include "l86.hpp"
#include "mbed.h"
#include "board.h"
#include "radio.h"
#include "LoRaMac.h"

#define APPDATA_SIZE 45
#define LORAWAN_DEFAULT_DATARATE DR_0
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x01234567
#define LORAWAN_NWKSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }
#define LORAWAN_APPSKEY                             { 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }

char AppDatas[APPDATA_SIZE];
static uint8_t NwkSKey[] = LORAWAN_NWKSKEY;
static uint8_t AppSKey[] = LORAWAN_APPSKEY;

mbed::Serial *gps;
mbed::Serial *pc;
EventQueue eventQueue(32 * EVENTS_EVENT_SIZE);
EventQueue eventQueue2(32 * EVENTS_EVENT_SIZE);
Thread t(osPriorityHigh);
Thread t2(osPriorityNormal);
DigitalOut GPS_status(LED2);

RMC_data RMC;
GPS_data GPS_parse;
volatile int Char_index = 0;                  // index for char array
char Rx_data[MAX_NMEA_LENGTH] = "0";          // char array to store received bytes
//char c = 'c';
char incoming = '$';

volatile bool GPS_data_ready = false;
McpsReq_t mcpsReq;

Ticker LoRaSend_timer;

void post_to_queue();
void LoRaSend_queue();
void LoRaSend();
void createLoRaMessage();

extern "C" void HardFault_Handler()
{
    pc->putc('c');
    NVIC_SystemReset();
}
 
extern "C" void UsageFault_Handler()
{
    pc->putc('c');
    NVIC_SystemReset(); 
}
 
extern "C" void  BusFault_Handler()
{
    pc->putc('c');
    NVIC_SystemReset();
}
 
extern "C" void MemManage_Handler()
{
    pc->putc('c');
    NVIC_SystemReset();
}
void printtext(){
    //__disable_irq();
    while((incoming != '\n')){// && (GPS_data_ready == false)){
        incoming = gps->getc();
        //pc->putc(incoming);
        //pc->putc('G');
        Rx_data[Char_index] = incoming;
        if(incoming=='\n'){
            if(Rx_data[2] == 'R'){
                RMC = Parse_RMC_sentence(Rx_data);
                GPS_parse = Parse_RMC_data(RMC); // trying doing this in LoRaSend?
                if(strcmp(RMC.Status, "A") == 0){
                    // GPS_status = 0;    // Turn status LED off
                    //LoRaSend();
                }
                else{
                    // GPS_status = 1;
                }
                //GPS_status=!GPS_status;
                //GPS_parse = Parse_RMC_data(RMC); // Parse into format suitable for Tom (Dinghy_RaceTrak software)
                GPS_data_ready = true;
                //Print_GPS_data(GPS_parse);
                //LoRaSend();
            }    
            Rx_data[Char_index] = 0;
            Char_index = 0;
            incoming = 'X';
            gps->attach(post_to_queue, Serial::RxIrq);
            //LoRaSend_timer.attach(&LoRaSend_queue, 0.4);
            //__enable_irq();
            return;
        }
        else{
            Char_index++;
        }
    }
    //LoRaSend_timer.attach(&LoRaSend_queue, 0.4);
   //__enable_irq();
}

void post_to_queue(){
    //__disable_irq();
    gps->attach(NULL, Serial::RxIrq);
    //LoRaSend_timer.detach();
    eventQueue.call(printtext);
}

void createLoRaMessage(){
    strcpy(AppDatas, GPS_parse.Latitude); 
    strcat(AppDatas, ",");
    strcat(AppDatas, GPS_parse.Longitude);
    strcat(AppDatas, ",");
    strcat(AppDatas, GPS_parse.Course_Over_Ground);
    strcat(AppDatas, ",");
    strcat(AppDatas, GPS_parse.Speed_Over_Ground);
    strcat(AppDatas, ",");
    strcat(AppDatas, GPS_parse.UTC_Time);
    strcat(AppDatas, ",");
    strcat(AppDatas, GPS_parse.Valid);
    mcpsReq.Req.Unconfirmed.fBuffer = AppDatas;   
}

void LoRaSend(){
    //__disable_irq();//NVIC_DisableIRQ(USART1_IRQn);
    pc->putc('t');
    if(GPS_data_ready == true){
        GPS_data_ready = false;
        //RMC = Parse_RMC_sentence(Rx_data);
        //GPS_parse = Parse_RMC_data(RMC);
        Print_GPS_data(GPS_parse);
        GPS_status = !GPS_status;
        createLoRaMessage();
        LoRaMacMcpsRequest( &mcpsReq );
        //pc->putc('T');
    }
    //__enable_irq();//NVIC_EnableIRQ(USART1_IRQn);
    //LoRaSend_timer.attach(LoRaSend_queue, 1.0);
    //gps->attach(post_to_queue, Serial::RxIrq);
    //NVIC_SystemReset();
    //__enable_irq();
}

void LoRaSend_queue(){
    //__disable_irq();
    //gps->attach(NULL, Serial::RxIrq);
    //LoRaSend_timer.detach();
    eventQueue2.call(LoRaSend);
}

void McpsConfirm( McpsConfirm_t *mcpsConfirm )
{
    return;
}
 
void McpsIndication( McpsIndication_t *mcpsIndication )
{
    return;
}
 
 
int main(){
    //Initialise firmware
    // reset = 1;
    LoRaMacPrimitives_t LoRaMacPrimitives;
    LoRaMacCallback_t LoRaMacCallbacks;
    MibRequestConfirm_t mibReq;
 
    LoRaMacPrimitives.MacMcpsConfirm = McpsConfirm;
    LoRaMacPrimitives.MacMcpsIndication = McpsIndication;
//    LoRaMacPrimitives.MacMlmeConfirm = McpsConfirm;
    LoRaMacInitialization( &LoRaMacPrimitives, &LoRaMacCallbacks );
 
    LoRaMacChannelAdd( 3, ( ChannelParams_t ){ 868100000, { ( ( DR_5 << 4 ) | DR_5 ) }, 3 } );
    //LoRaMacChannelAdd( 4, ( ChannelParams_t ){ 867300000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 5, ( ChannelParams_t ){ 867500000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 6, ( ChannelParams_t ){ 867700000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 7, ( ChannelParams_t ){ 867900000, { ( ( DR_5 << 4 ) | DR_0 ) }, 0 } );
    //LoRaMacChannelAdd( 8, ( ChannelParams_t ){ 868800000, { ( ( DR_7 << 4 ) | DR_7 ) }, 2 } );
    //LoRaMacChannelAdd( 9, ( ChannelParams_t ){ 868300000, { ( ( DR_6 << 4 ) | DR_6 ) }, 1 } );
 
    //Join ABP
 
    mibReq.Type = MIB_NET_ID;
    mibReq.Param.NetID = 0;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_DEV_ADDR;
    mibReq.Param.DevAddr = LORAWAN_DEVICE_ADDRESS;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_NWK_SKEY;
    mibReq.Param.NwkSKey = NwkSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_APP_SKEY;
    mibReq.Param.AppSKey = AppSKey;
    LoRaMacMibSetRequestConfirm( &mibReq );
 
    mibReq.Type = MIB_NETWORK_JOINED;
    mibReq.Param.IsNetworkJoined = true;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_TX_POWER;
    mibReq.Param.ChannelsTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
    mibReq.Type = MIB_CHANNELS_DEFAULT_TX_POWER;
    mibReq.Param.ChannelsDefaultTxPower = LORAMAC_MAX_TX_POWER;
    LoRaMacMibSetRequestConfirm( &mibReq );
    
     uint8_t AppPort = 3;
    mcpsReq.Type = MCPS_UNCONFIRMED;
    mcpsReq.Req.Unconfirmed.fPort = AppPort;
    mcpsReq.Req.Unconfirmed.fBuffer = AppDatas;
    mcpsReq.Req.Unconfirmed.fBufferSize = APPDATA_SIZE+2;
    mcpsReq.Req.Unconfirmed.Datarate = DR_5;
    
    t.start(callback(&eventQueue, &EventQueue::dispatch_forever));
    t2.start(callback(&eventQueue2, &EventQueue::dispatch_forever));
    pc = new Serial(USBTX, USBRX);
    gps = new Serial(GPS_TX, GPS_RX);
    GPS_status = 1;
    gps->attach(&post_to_queue, Serial::RxIrq);
    //gps->attach(&printtext, Serial::RxIrq);
    gps->printf(PMTK_SET_NMEA_OUTPUT_RMC); // Only output RMC and GPTXT
    wait(1.0);
    gps->printf(PMTK_SET_UPDATE_F_2HZ);    // Set update Frequency to 2Hz
    wait(1.0);
    gps->printf(PMTK_SET_NMEA_OUTPUT_RMC);
    wait(1.0);
    gps->printf(PMTK_SET_UPDATE_F_2HZ);
    LoRaSend_timer.attach(eventQueue2.event(&LoRaSend), 1.0);
    //NVIC_SetPriority(USART1_IRQn, 0);
}