#include "mbed.h"

// --Entrées--//
//Capteurs ligne :
DigitalIn gext_CAPTEURS_LIGNE (A0); // Capteur gauche exterieur
DigitalIn gmid_CAPTEURS_LIGNE (A1); // Capteur gauche milieu
DigitalIn dmid_CAPTEURS_LIGNE (A2); // Capteur droit milieu
DigitalIn dext_CAPTEURS_LIGNE (A3); // Capteur Droit exterieur
//Capteurs Vitesse :
AnalogIn CptVitesse_1 (D9);
AnalogIn CptVitesse_2(D8);
//Jack :
DigitalIn Jack(D5);
//Bouton poussoir :
DigitalIn BpPoussoir(D2);
//Fin de course :
DigitalIn Fdc(D4);
//Capteur Ultra Son :
AnalogIn IN_US(D1);

//--Sorties--//
//Moteurs :
PwmOut Moteur_gauche(D6);
PwmOut Moteur_Droit(D7);
//Capteur Ultra Son
PwmOut OUT_US(D0);


PwmOut led_BLUE(LED_BLUE);
PwmOut led_GREEN(LED_GREEN);
PwmOut led_RED(LED_RED);

double rp_cycl_droit = 0, rp_cycl_gauche = 0;
int valid = 0;
int main()
{
    led_GREEN = 1;
    led_RED = 0;
    led_BLUE = 1;

    while(Jack);
    while ( rp_cycl_droit < 0.6) {
        rp_cycl_droit +=0.05;
        rp_cycl_gauche += 0.05;
        wait (0.25);
        led_GREEN = 0;
        led_RED = 1;
        led_BLUE = 1;
        wait_ms(0.25);
    }
    while(!Fdc) {

        if (dext_CAPTEURS_LIGNE == 1 && gext_CAPTEURS_LIGNE == 1) { //Si tous les capteurs captent...
            rp_cycl_droit = 0.6;
            rp_cycl_gauche = 0.6;
        } else { //...Sinon...
            rp_cycl_droit = (1 / (1 + dext_CAPTEURS_LIGNE))/10*6;
            rp_cycl_gauche = (1/ (1 + gext_CAPTEURS_LIGNE))/10*6;
        }
        //Arret des moteurs
        rp_cycl_droit = 0;
        rp_cycl_gauche = 0;


    }

}






