#define Exo2
#ifdef  Exo2

#include "mbed.h"
#include "info1.h"
#include "TSISensor.h"

#define LOW 0
#define HIGH 1

//pour le debug (printf & scanf)
Serial pc(USBTX, USBRX);

int main(void)
{
    //Declaration des variables :
    int etat;
    int bp,bp1,bp2,bp3,bp4;
    PwmOut led_BLUE(LED_BLUE);
    PwmOut led_GREEN(LED_GREEN);
    PwmOut led_RED(LED_RED);
    TSISensor tsi2;
    //Initialisation
    etat=0;
    led_RED.period_us(100);
    led_BLUE.period_us(100);
    led_GREEN.period_us(100);

    //Boucle infinie
    while (1) {
        //Lecture du slider (bp=1 si doigt sur slider, 0 sinon)
        appui_num(&bp);
        appui_ana_2(&bp1,&bp2,&bp3,&bp4); 
        /*
        Quatre zones sont définies :
        0 à 0.15 : Simulation du retrait du jack
        0.15 à 0.5 : Virage à gauche
        0.5 à 0.95 : Virage à droite
        0.95 à 1 : Fin de course
        */
        
        
        //Determination de l'etat en fonction de BP
        switch(etat) {
            case 0 :
                if (bp1 == 1)
                    etat = 1;
                break;
            case 1 :
                if (bp4 == 1)
                    etat = 0;
                else 
                    etat = 2;
                break;
            case 2 :
                if (bp4 == 1)
                    etat = 0;
                else if (bp2 == 0 && bp3 == 0)
                    etat = 2;
                else if (bp2 == 1 && bp3 == 0)
                    etat = 3;
                else if (bp2 == 0 && bp3 == 1)
                    etat = 4;
                
                break;
        }
        printf("Etat = %d ; bp1 = %d ; bp2 = %d\n",etat,bp1,bp2);

        //Ecriture sur les sorties en fct de l'etat
        switch(etat) {
            case 0 :
                led_RED = 1;
                led_BLUE = 1;
                led_GREEN = 1;
                break;
            case 1 :
                led_RED = 1;
                led_BLUE = 1;
                led_GREEN = 0;
                break;
            case 2 :
                led_RED = 1;
                led_BLUE = 1;
                led_GREEN = 0;
                break;
            case 3 :
                led_RED = 0 + (tsi2.readPercentage()-0.15)*2.8; 
                /*
                A 15% du slider la LED rouge est à 100% de son intensité;
                On soustrait 0.15 car on veut une intensité de 100% a 15% du slider;
                L'intensité diminue progréssivement avec un rapport de 2.8;
                A 50% du slider l'intensité de la LED est à 0;
                */
                led_BLUE = 1;
                led_GREEN = 1 - (tsi2.readPercentage()-0.15)*2.8;//Idem que la LED rouge sauf que l'intensité augmente;
                etat = 2;
                break;
            case 4 :
                /*
                Même principe sauf que le repport est de 2.2;
                */
                led_RED = 1;
                led_BLUE = 1 - (tsi2.readPercentage()-0.5)*2.2;
                led_GREEN = (tsi2.readPercentage()-0.5)*2.2;
                etat = 2;
                break;
            

        }

        wait_ms(10);
    }
}
#endif
