#include "mbed.h"

DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

DigitalIn bp1(p21);
DigitalIn bp2(p22);
DigitalIn bp3(p23);

Timer timer;
int tab[3] = {0};
int in[3] = {0};
bool perdu = false;
bool gagner = false;

int main()
{
    srand(time(NULL));

    while(1) {
        for (int i = 0; i < 3;i++)
            in[i] =0;
        for (int i = 0; i < 3; i++)
            tab[i] = (rand()%3) + 1;
        for (int i =0; i < 3; i++) {
            switch(tab[i]) {
                case 1:
                    myled.write(1);
                    break;
                case 2:
                    myled2.write(1);
                    break;
                case 3:
                    myled3.write(1);
                    break;
            }
            wait(1);
            myled.write(0);
            myled2.write(0);
            myled3.write(0);
            wait(0.5);
        }
        timer.start();
        while(timer.read_ms() < 500 && !perdu && !gagner) {
            int i = 0;
            if (bp1)
                in[i] = 1;
            if (bp2)
                in[i] = 2;
            if (bp3)
                in[i] = 3;
            if (in[i] != 0 && in[i] == tab[i]) {
                i++;
                timer.reset();
                if ( i == 3)
                    gagner = true;
                    myled = 1;
                    myled2 = 1;
                    myled3 = 1;
                    wait(1);
            }
            if (in[i] != 0 && in[i] != tab[i]) {
                perdu = true;
            }
        }
    }
}
