#include "mbed.h"
#include "EthernetInterface.h"

#define WEB_SERVER_PORT   80

char HTTP[1024]={0,};
char HTML[1024]={0,};     
                
Serial pc(USBTX, USBRX);
int main (void) 
{
    pc.printf("Wait a second...\n\r");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x05, 0x01}; 
//    const char ip_addr[] = "192.168.0.222"; 
//    const char mask_addr[] = "255.255.255.0"; 
//    const char gateway_addr[] = "192.168.0.1";
    
    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    //eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    pc.printf("Server IP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(WEB_SERVER_PORT);
    server.listen();
    
    sprintf(HTML, "<!DOCTYPE html>\r\n"\
                    "<html>\n\r"\
                    "<body>\n\r"\
                    "<form action=\"1\"><input type=\"submit\" value=\"up\" /></form>\n\r"\
                    "<form action=\"2\"><input type=\"submit\" value=\"down\" /></form>\n\r"\
                    "<form action=\"3\"><input type=\"submit\" value=\"forward\" /></form>\n\r"\
                    "</body>\n\r"\
                    "</html>\n\r");  
    
    sprintf(HTTP, "HTTP/1.1 200 OK \n\r"\
                    "Content-Length: %d\n\r"\
                    "Content-Type: text/html\n\r"\
                    "Connection: close\n\r\n\r", strlen(HTML));

    while (true) 
    {
        pc.printf("Wait for new connection...\n\r");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        //pc.printf("Connection from: %s\n\r", client.get_address());
        char buffer[1024];
        
        while (true) {
            int n = client.receive_all(buffer, sizeof(buffer));
            if (n <= 0) break;
            buffer[n] = '\0';
            
            //pc.printf("rev_dat : %s\n\r", buffer);
            
            if((buffer[0]=='G')&&(buffer[1]=='E')&&(buffer[2]=='T')&&(buffer[3]==' '))// GET_Request
            { 
                client.send(HTTP, strlen(HTTP));   
                client.send(HTML, strlen(HTML));  
                //pc.printf("send_dat : %s\n\r", send_dat);
            }
            if (n <= 0) break;
        }
        
        client.close();
    }
    
}
 