#include "mbed.h"
#include "EthernetInterface.h"
#include "CameraC328.h"

/* CAMERA */
#define USE_JPEG_HIGH_RESOLUTION    3//1=80x64 <--- not working -_-;;, 2=160x128, 3=320x240, 4=640x480
#define START                       "start"
#define END                         "end"
CameraC328 camera(PA_13, PA_14, CameraC328::Baud115200);

/* TCP/IP */
static char buf[1024];
const char dest_ip[] = "192.168.0.11";
int dest_port = 1212;

uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x12, 0x34, 0x45};
const char ip_addr[] = "192.168.0.123"; 
const char mask_addr[] = "255.255.255.0"; 
const char gateway_addr[] = "192.168.0.1"; 


EthernetInterface eth;
TCPSocketConnection Streaming;

/* UART */
Serial pc(USBTX, USBRX);

/* Function*/ 
void jpeg_callback(char *buf, size_t siz);
void sync(void);
void test_jpeg_snapshot_picture(void);
void init(void);

int main() {

    printf("WIZKon Telescope\r\n"); 
      
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    while(1) 
    { //Wait link up
        if(eth.link() == true)
            break;
    }
    printf("My IP Address is %s\n\r", eth.getIPAddress());
    sync();
    init();
    while (Streaming.connect(dest_ip, dest_port) < 0) {
        printf("Unable to connect to (%s) on port (%d)\r\n", dest_ip, dest_port);
        wait(1);
    }
    
    while(true)
    {
        int n = Streaming.receive(buf, sizeof(buf));
        buf[n] = '\0';
            
        Streaming.send(START, sizeof(START)-1);
        test_jpeg_snapshot_picture();
        Streaming.send(END, sizeof(END)-1); 
    }
}

void jpeg_callback(char *buf, size_t siz) {
    //for (int i = 0; i < (int)siz; i++) {
        //fprintf(fp_jpeg, "%c", buf[i]);
        Streaming.send(buf, siz);
    //}
}
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\r\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\r\n", (int)err);
    }
}
void test_jpeg_snapshot_picture() {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.getJpegSnapshotPicture(jpeg_callback);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::getJpegSnapshotPicture\r\n");
    } else {
        printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
    }
}
void init()
{
    CameraC328::ErrorNumber err = CameraC328::NoError;

#if (USE_JPEG_HIGH_RESOLUTION==1)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
#elif (USE_JPEG_HIGH_RESOLUTION==2)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
#elif (USE_JPEG_HIGH_RESOLUTION==3)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution320x240);
#elif (USE_JPEG_HIGH_RESOLUTION==4)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
#endif
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\r\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\r\n", (int)err);
    }
}