#include "mbed.h"
#include "EthernetInterface.h"

#define DHCP 1

uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x45, 0x56, 0x67};
const char ip_addr[] = "xxx.xxx.xxx.xxx"; 
const char mask_addr[] = "xxx.xxx.xxx.xxx"; 
const char gateway_addr[] = "xxx.xxx.xxx.xxx"; 

const char* Target_addr = "192.168.0.2";
const int Target_port = 22222;


SPISlave slave(PA_8, PA_7, PA_6, PA_5); // mosi, miso, sclk, ssel
 
int main() {
    
    /**(volatile uint32_t *)(0x41001014) = 0x0060100;
    *(volatile uint32_t *)(0x41003000) = 0x10;
    *(volatile uint32_t *)(0x41003004) = 0x10;
    *(volatile uint32_t *)(0x41003008) = 0x10;
    *(volatile uint32_t *)(0x41003080) = 0x10;
    *(volatile uint32_t *)(0x41003098) = 0x10;*/
    
    int SPI_Data=0;
    int SPI_Send_Cnt=0;
    int Length=0;
    char Eth_Receive_Check_Flag = 1;
    char EthTx[1]={0};
    char EthRx[1]={0,};
    int test;

    printf("SPI to Ethernet Slave\r\n");
  
    /*
    * SPI Setting
    */
    slave.format(8,3);
    slave.frequency(1000000);
    /*
    * Network Setting
    */
    printf("Wait a second...\r\n");
    EthernetInterface eth;
    #if DHCP==1
        printf("Network Setting DHCP\r\n");
        eth.init(mac_addr); 
    #else
        printf("Network Setting Static\r\n");
        eth.init(mac_addr, ip_addr, mask_addr, gateway_addr);
    #endif
    eth.connect();
    printf("IP Address is %s\r\n", eth.getIPAddress());
    while(1) 
    { 
        printf("Check Ethernet Link\r\n");
        if(eth.link() == true)
        {
            printf("Link up\r\n");
            break;
        }
    }
    
    /*
    * Create Client Socket and Connecting
    */
    TCPSocketConnection socket;
    while(1)
    {       
        while (socket.connect(Target_addr, Target_port) < 0) 
        {
            printf("Unable to connect to (%s) on port (%d)\r\n", Target_addr, Target_port);
            wait(1);
        }
        printf("Connected to Server at %s\r\n",Target_addr);
        
        while(1)
        {
            if(slave.receive())
            {
                socket.receive(EthRx, sizeof(EthRx));
                slave.reply(EthRx[0]);
            }
            
        }
    }
}