#include "mbed.h"
#include "EthernetInterface.h"

#define DHCP 1

uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x12, 0x34, 0x45};
const char ip_addr[] = "xxx.xxx.xxx.xxx"; 
const char mask_addr[] = "xxx.xxx.xxx.xxx"; 
const char gateway_addr[] = "xxx.xxx.xxx.xxx"; 

const char* Target_addr = "192.168.0.2";
const int Target_port = 11111;

SPI master(PA_8, PA_7, PA_6, PA_5); // mosi, miso, sclk
 
int main() {

    char EthTx[256]={0,};
    int i, n;

    printf("SPI to Ethernet Master\r\n");
    
    /*
    * SPI Setting
    */
    master.format(8,3);
    master.frequency(1000000);
    
    /*
    * Network Setting
    */
    printf("Wait a second...\r\n");
    EthernetInterface eth;
    #if DHCP==1
        printf("Network Setting DHCP\r\n");
        eth.init(mac_addr); 
    #else
        printf("Network Setting Static\r\n");
        eth.init(mac_addr, ip_addr, mask_addr, gateway_addr);
    #endif
    eth.connect();
    printf("IP Address is %s\r\n", eth.getIPAddress());
    while(1) 
    { 
        printf("Check Ethernet Link\r\n");
        if(eth.link() == true)
        {
            printf("Link up\r\n");
            break;
        }
    }
    
    /*
    * Create Client Socket and Connecting
    */
    TCPSocketConnection socket;
    while(1)
    {       
        while (socket.connect(Target_addr, Target_port) < 0) 
        {
            printf("Unable to connect to (%s) on port (%d)\r\n", Target_addr, Target_port);
            wait(1);
        }
        printf("Connected to Server at %s\r\n",Target_addr);
        
        while(1)
        {
            if((n = socket.receive(EthTx, sizeof(EthTx)))>0)
            {
                for(i=0; i<n; i++)
                {
                    master.write(EthTx[i]);
                }
                memset(EthTx, 0, strlen(EthTx));
            }  
        }
    }
}


