#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#include "FTPClient.h"
 #include "VS1002.h" 
 #include "TextLCD.h"

#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.77.191"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.77.1"

#define FTP_SERVER_IP "192.168.77.209"

#define _MAX_FNAME_LEN_   127
#define _FTP_UPDATE_TIME_  20


Serial uart(USBTX, USBRX);

//SDFileSystem sd(p5, p6, p7, p8, "sd"); // LPC1768 MBD2PMD
//SDFileSystem sd(P0_18, P0_17, P0_15, P0_16, "sd"); // Seeeduino Arch Pro SPI2SD
//SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // K64F
//SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 

EthernetInterface eth;

DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status

InterruptIn K_VU(D3); // Create the interrupt receiver object on pin 26
InterruptIn K_NT(D4); // Create the interrupt receiver object on pin 26
InterruptIn K_PS(D5); // Create the interrupt receiver object on pin 26
InterruptIn K_BK(D6); // Create the interrupt receiver object on pin 26
InterruptIn K_VD(D7); // Create the interrupt receiver object on pin 26
VS1002 mp3(PB_3, PB_2, PB_1, PB_0,"sdc",D11, D12 ,D13, PC_12, PC_15, PC_14, PC_13);  //Setup Audio decoder. Name is VS1002 even though VS1053 is used.
TextLCD lcd1(D8, D9, D0, D1, D2, D15); //setup lcd

FTPClient myFTP("/sdc");  // mountname in MySeeedStudioTFTv2

Ticker ledTick;

/* Global Variables to store Status*/
int new_song_number=1;  //Variable to store the Song Number
int volume_set=-20;     //Variable to store the Volume
int previous_volume;    //Variable to store the volume when muted
bool pause=false;       //Variable to store the status of Pause button 
bool mute=false;        //Variable to store the status of mute button

int check=0;    //Capacitative touch generates interrupt on both press and release. This variable tracks this and updates only on press.
char *song_name[9]={"Good Day","Leong","Sponsor","I'm So Sexy","My Life","Oh My god","Wonderful bar","Whale Hunting","Love"}; //Array of song names entered manually

uint32_t ftp_time_1s = 0;

char myfilelist[MAX_SS] = {0,};

void ledTickfunc()
{
    led1 = !led1;
    if(ftp_time_1s)
    {
        if(ftp_time_1s++ > _FTP_UPDATE_TIME_) ftp_time_1s = 0;
    }
}

void Next_Song() 
{
    new_song_number+=1;  // Next Song
    if(new_song_number==10)
        new_song_number=1;
        
    lcd1.cls();
    if(pause) 
        lcd1.printf("     Paused ");
    else
        lcd1.printf("     Playing..."); 
    
    lcd1.printf("\n %d %s",new_song_number,song_name[new_song_number-1]);
}

void Preveious_Song() 
{
    new_song_number-=1;  // Preveious Song
    if(new_song_number==0)
        new_song_number=9;
        
    lcd1.cls();
    if(pause) 
        lcd1.printf("     Paused ");
    else
        lcd1.printf("     Playing..."); 
    
    lcd1.printf("\n %d %s",new_song_number,song_name[new_song_number-1]);
}

void Pause_Song() 
{
    pause=!pause; // Pause/Play button
    
    lcd1.cls();
    if(pause) 
        lcd1.printf("     Paused ");
    else
        lcd1.printf("     Playing..."); 
    
    lcd1.printf("\n %d %s",new_song_number,song_name[new_song_number-1]);
}

void Volume_Up() 
{
    volume_set+=3; // Volume Up
    if(volume_set>=0)
        volume_set=0;
}

void Volume_Down() 
{
    volume_set-=3;  //Volume Down
    if(volume_set<-55)
        volume_set=-55;
}
/*
void Volume_Mute() 
{
    mute=!mute;  //Mute/Unmute
    
    if(mute)
    {
        previous_volume=volume_set; // Attenuation of -55 db is small enough to not hear anything
        volume_set=-55;
    }
    else
    {
        volume_set=previous_volume;
    }
}*/

int main (void)
{
    *(volatile uint32_t *)(0x41001014) = 0x0060100;
    *(volatile uint32_t *)(0x41003000) = 0x10;
    *(volatile uint32_t *)(0x41003004) = 0x10;
    *(volatile uint32_t *)(0x41003008) = 0x10;
    *(volatile uint32_t *)(0x41003080) = 0x10;
    *(volatile uint32_t *)(0x41003098) = 0x10;
    
    char* tok = NULL;
    char* lasts = NULL;
    char filename[_MAX_FNAME_LEN_];
    FILE* fp;
    
//    Serial Interface eth;
    uart.baud(115200);
    uart.printf("Initializing\r\n");

//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\r\n");

    //eth.init(); //Use DHCP
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    uart.printf("Connecting\r\n");
    eth.connect();
    uart.printf("IP Address is %s\r\n", eth.getIPAddress());

//    Check File System
    uart.printf("Checking File System\r\n");
    DIR *d = opendir("/sdc/");
    if (d != NULL) {
        uart.printf("SD Card Present\r\n");
        closedir(d);
    } else {
        uart.printf("SD Card Root Directory Not Found\r\n");
    }

    ledTick.attach(&ledTickfunc,1);

    while(1)
    {
        if(ftp_time_1s == 0)
        {
            //Configure the display driver
            ftp_time_1s = 1;
            
            printf(" UPDATING MP3\r\n");
            printf("==================\n\r\n");
            myFTP.open("192.168.77.209", 21, "user", "pass");
        
            if(myFTP.open("192.168.77.209", 21, "user", "pass"))
            {
                printf("Connect Success to FTPServer\r\n");
                printf("Connected to FTP Server\r\n");

                myFTP.ls(myfilelist);
            
                if(*myfilelist !=0)
                {
                    tok = myfilelist;
                    while(tok)
                    {
                        tok = strtok_r(tok,"\r\n",&lasts);
                        if(tok != NULL)
                        {
                            printf("tok=%s\r\n",tok);
                            if(strstr(tok,"mp3"))
                            {
                                sprintf(filename,"/sdc/%s",tok);
                                fp = fopen(filename, "r");
                                printf("fp=%d\r\n",fp);
                                if(fp==NULL)
                                {
                                    myFTP.getfile(tok);
                                    printf("Get File : %s\r\n",tok);
                                    printf("New file : %s\r\n",tok);
                                }
                                else fclose(fp);
                            }
                            tok = lasts;
                        }
                    }
                }
                else printf(" Empty FTP Server\r\n");
                printf("\n UPDATE DONE\n\r\n");
                myFTP.quit();
            }
            else
            {
                printf(" Can't connect to FTP Server\r\n");
                printf(" UPDATE FAIL\r\n");
            }
            printf("==================\n");
        }
        
        /*============================================================ 
         * MP3 Initialising 
         *==========================================================*/

        mp3._RST = 1; 
        mp3.cs_high();                                  //chip disabled 
        mp3.sci_initialise();                           //initialise MBED
        mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF)); 
        mp3.sci_write(0x03, 0x9800); 
        mp3.sdi_initialise();

        /* UI Button setup */
        K_VU.fall(&Volume_Up);
        K_VU.mode(PullUp);
        K_VD.fall(&Volume_Down);
        K_VD.mode(PullUp);
        K_NT.fall(&Next_Song);
        K_NT.mode(PullUp);
        K_BK.fall(&Preveious_Song);
        K_BK.mode(PullUp);
        K_PS.fall(&Pause_Song);
        K_PS.mode(PullUp);
        
        while(1)
        {
            mp3.play_song(new_song_number);
        }
    }    
}
