/*
 /* Copyright (C) 2014 Wiznet, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include "mbed.h"
#include "WizFi250Interface.h"
#include "CameraC328.h"

#define SECURE WizFi250::SEC_AUTO
#define SSID "Ricky"
#define PASS "ricky123"

//#define ECHO_SERVER_ADDRESS "192.168.0.2"
//#define ECHO_SERVER_PORT    5000

/* CAMERA */
#define USE_JPEG_HIGH_RESOLUTION    2//1=80x64 <--- not working -_-;;, 2=160x128, 3=320x240, 4=640x480
#define START                       "start"
#define END                         "end"
CameraC328 camera(PC_10, PC_11, CameraC328::Baud115200);

/* NETWORK */
#if defined(TARGET_FRDM_KL25Z)
    WizFi250Interface wizfi250(PTE0,PTE1,PTD5,PTD0,PTD4,NC,115200);
#else
    WizFi250Interface wizfi250(D1,D0,D7,D8,PA_12,NC,115200);
    //Serial pc(USBTX, USBRX);
    //Serial pc2(PC_10,PC_11);
#endif
TCPSocketConnection Streaming;
const char dest_ip[] = "192.168.0.2";
int dest_port = 1212;
static char buf[128];


/* Function*/ 
void jpeg_callback(char *buf, size_t siz);
void sync(void);
void test_jpeg_snapshot_picture(void);

int main()
{

        wizfi250.init();
        if ( wizfi250.connect(SECURE, SSID, PASS))      return -1;
        printf("IP Address is %s\r\n", wizfi250.getIPAddress());

        sync();
        while (Streaming.connect(dest_ip, dest_port) < 0) {
            printf("Unable to connect to (%s) on port (%d)\r\n", dest_ip, dest_port);
            wait(1);
        }
    
        while(1)
        {
            Streaming.send(START, sizeof(START)-1);
            test_jpeg_snapshot_picture();
            Streaming.send(END, sizeof(END)-1);
        }

}

void jpeg_callback(char *buf, size_t siz) {
    //for (int i = 0; i < (int)siz; i++) {
        //fprintf(fp_jpeg, "%c", buf[i]);
        Streaming.send(buf, siz);
    //}
}
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\r\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\r\n", (int)err);
    }
}
void test_jpeg_snapshot_picture() {
    CameraC328::ErrorNumber err = CameraC328::NoError;

#if (USE_JPEG_HIGH_RESOLUTION==1)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
#elif (USE_JPEG_HIGH_RESOLUTION==2)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
#elif (USE_JPEG_HIGH_RESOLUTION==3)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution320x240);
#elif (USE_JPEG_HIGH_RESOLUTION==4)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
#endif
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\r\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\r\n", (int)err);
    }

    err = camera.getJpegSnapshotPicture(jpeg_callback);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::getJpegSnapshotPicture\r\n");
    } else {
        printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
    }
}

