#include "mbed.h"
#include "EthernetInterface.h"
#include "AX12.h"
#define WEB_SERVER_PORT   80
char send_dat[1024]={0,};
uint16_t calcu_len(void);
float tempC;
AnalogIn   ain(A0); // connect A0(WIZwiki-W7500) to Vout(Temp36)
AX12 feed (PA_13, PA_14, 2);
int main (void) 
{
    printf("Wait a second...\r\n");
    uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02}; 
    const char ip_addr[] = "192.168.0.222"; 
    const char mask_addr[] = "255.255.255.0"; 
    const char gateway_addr[] = "192.168.0.1";
    
    uint16_t len;
    EthernetInterface eth;
    //eth.init(mac_addr); //Use DHCP
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    printf("Server IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(WEB_SERVER_PORT);
    server.listen();
    feed.SetGoal(939,1);
    while (true) 
    {
        printf("Wait for new connection...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s
        
        printf("Connection from: %s\r\n", client.get_address());
        char buffer[256];
        char dat[128];
        char *dat_temp;
        
        memset(dat, 0, sizeof(dat));
        memset(send_dat, 0, sizeof(send_dat));
        memset(buffer, 0, sizeof(buffer));
        
        while (true) {
            
            wait(0.5);
            int n = client.receive_all(buffer, sizeof(buffer));
            if (n <= 0) break;
            //buffer[n] = '\0';
            
            printf("rev_dat : %s\r\n", buffer);
            
            float V = ain.read() * 3.3; // connect Vs(Temp36) to 3.3V(WIZwiki-W7500)      
            tempC = (V-0.5) * 100; // calculate temperature C
                       
            if((buffer[0]=='G')&&(buffer[1]=='E')&&(buffer[2]=='T')&&(buffer[3]==' '))// GET_Request
            { 
                if((buffer[5]=='?'))
                {
                    feed.SetGoal(554,1);
                    feed.SetGoal(554,1);
                    wait(1.0);
                    feed.SetGoal(939,1);
                    feed.SetGoal(939,1);
                }
                dat_temp = "HTTP/1.1 200 OK\r\n";                           strcat(dat, dat_temp);
                dat_temp = "Content-Type: text/html\r\n";                   strcat(dat, dat_temp);
                dat_temp = "Connection: close\r\n";                         strcat(dat, dat_temp);
                //len = calcu_len();
                sprintf(dat, "%sContent-Length: %d\r\n\r\n", dat, calcu_len());     strcat(dat, dat_temp);
            
                client.send(dat, strlen(dat));
                printf("send_dat : %s\r\n", dat);
            
                client.send(send_dat, sizeof(send_dat));   
                printf("send_dat : %s\r\n", send_dat);
                //printf("send_dat size : %d\r\n", len);
                
                memset(dat, 0, sizeof(dat));
                memset(send_dat, 0, sizeof(send_dat));
                memset(buffer, 0, sizeof(buffer));
            }
            
        }
        
        client.close();
    }
    
}
uint16_t calcu_len(void)
{
    char * dat_temp;
    char * forbidden = NULL;
    char str[4]={0,};

    //dat_temp = "<!DOCTYPE HTML>\r\n";                                                                       strcat(send_dat, dat_temp);
    dat_temp = "<html>\r\n";                                                                                strcat(send_dat, dat_temp);
    dat_temp = "\r\n";                                                                                  strcat(send_dat, dat_temp);
    dat_temp = "<head>\r\n";                                                                                strcat(send_dat, dat_temp);
    dat_temp = "<meta http-equiv=\"content-type\" content=\"text/html; charset=euc-kr\">\r\n";              strcat(send_dat, dat_temp);
    dat_temp = "<title>fishbowl</title>\r\n";                                                               strcat(send_dat, dat_temp);
    dat_temp = "<meta name=\"generator\" content=\"Namo WebEditor\">\r\n";                                  strcat(send_dat, dat_temp);
    dat_temp = "</head>\r\n";                                                                               strcat(send_dat, dat_temp);
    dat_temp = "\r\n";                                                                                      strcat(send_dat, dat_temp);
    dat_temp = "<body bgcolor=\"white\" text=\"black\" link=\"blue\" vlink=\"purple\" alink=\"red\">\r\n";  strcat(send_dat, dat_temp);
    dat_temp = "<p>fishbowl</p>\r\n";                                                                       strcat(send_dat, dat_temp);
    //dat_temp = "<p>&nbsp;</p>\r\n";                                                                         strcat(send_dat, dat_temp);
    dat_temp = "<p>Temperature in the fishbowl = $$$$$</p>\r\n";                                            strcat(send_dat, dat_temp);
    
    dat_temp = "<form name=\"form1\">\r\n";                                                                 strcat(send_dat, dat_temp);
    dat_temp = "<p><input type=\"hidden\" name=\"do\" value=\"ON\"></p>\r\n";                               strcat(send_dat, dat_temp);
    dat_temp = "<p>FEED <input type=\"button\" name=\"formbutton1\" value=\"ON\" onclick=\"submit();\"></p>\r\n";                   strcat(send_dat, dat_temp);
    dat_temp = "</form>\r\n";                                                                               strcat(send_dat, dat_temp);
    
    //dat_temp = "<p></p>\r\n";                                                                               strcat(send_dat, dat_temp);
    dat_temp = "</body>\r\n";                                                                               strcat(send_dat, dat_temp);
    dat_temp = "\r\n";                                                                                      strcat(send_dat, dat_temp);
    dat_temp = "</html>\r\n";                                                                               strcat(send_dat, dat_temp);
    forbidden = strstr(send_dat, "$$$$$");
    memset(forbidden,0,5);
    sprintf((char*)str, "%5.2f", tempC);
    memcpy(forbidden,str,5);

    return strlen(send_dat);
}
