#include "mbed.h"
#include "EthernetInterface.h"
#include "FTPClient.h"

uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x12, 0x34, 0x45};
const char ip_addr[] = "192.168.0.123"; 
const char mask_addr[] = "255.255.255.0"; 
const char gateway_addr[] = "192.168.0.1"; 

FTPClient ftp(PB_3, PB_2, PB_1, PB_0, "ftp");

int main (void) 
{
    int n;
    EthernetInterface eth;
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    
    n = ftp.open("192.168.0.2", 21, "abc", "123");
    if(n>1){
        printf("Connect Success to FTPServer\r\n");
    }
    printf("FTPServer dir...\r\n");
    ftp.dir();
    printf("FTPServer ls...\r\n");
    ftp.ls();
    
    ftp.getfile("/ftp/1.jpg", "1.jpg");
    ftp.getfile("/ftp/2.jpg", "2.jpg");
    ftp.getfile("/ftp/3.jpg", "3.jpg");
    ftp.getfile("/ftp/4.jpg", "4.jpg");
    
    ftp.mkdir("FTP Test");
    
    ftp.cd("FTP Test");
    
    ftp.putfile("/ftp/1.jpg", "1.jpg");
    ftp.putfile("/ftp/2.jpg", "2.jpg");
    ftp.putfile("/ftp/3.jpg", "3.jpg");
    ftp.putfile("/ftp/4.jpg", "4.jpg");
    
    printf("FTPServer dir...\r\n");
    ftp.dir();
    printf("FTPServer ls...\r\n");
    ftp.ls();
    
    ftp.cd("/");
    
    printf("FTPServer dir...\r\n");
    ftp.dir();
    printf("FTPServer ls...\r\n");
    ftp.ls(); 
    
    ftp.quit(); 
}






