#include "mbed.h"
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#include "CameraC328.h"


#define EnDebugMSG  true
#define NEWLINE()   printf("\r\n")
/* CAMERA */
#define USE_JPEG_HIGH_RESOLUTION    2//1=80x64 <--- not working -_-;;, 2=160x128, 3=320x240, 4=640x480
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "fs"); // the pinout on the mbed Cool Components workshop board
CameraC328 camera(PA_13, PA_14, CameraC328::Baud115200);
static FILE *fp_jpeg;
/* TCP/IP */
#define WEB_SERVER_PORT   80
char echoHeader[512] = {0,};
char line_response[8]= {0};
char sentBuffer[512] = {0,}; 
char recv_buffer[1024] = {0,};

uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x12, 0x34, 0x45};
const char ip_addr[] = "192.168.0.123"; 
const char mask_addr[] = "255.255.255.0"; 
const char gateway_addr[] = "192.168.0.1"; 

EthernetInterface eth;
TCPSocketServer server;


/* UART */
Serial pc(USBTX, USBRX);

/* Function*/ 
void jpeg_callback(char *buf, size_t siz);
void sync(void);
void test_jpeg_snapshot_picture(void);
void init(void);

int main() {

    unsigned int bytes_for_send=0;
    long long filesize, all_send_bytes = 0;
    
    printf("Hello WIZwiki-W7500 Camera WebStreaming World!\r\n"); 
      
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    
    sync();
    init();
    
    printf("WIZwiki-W7500 IP Address is %s\r\n", eth.getIPAddress());
    
    server.bind(WEB_SERVER_PORT);
    printf("bind complete\r\n");
    server.listen();
    printf("listen complete\r\n");
    
    while(true)
    {
        TCPSocketConnection Streaming;
        printf("Wait for new connection...\r\n");
        server.accept(Streaming);
        Streaming.set_blocking(false, 15000); // Timeout after (1.5)s
        
        if (EnDebugMSG)
        printf("Connection from: %s\r\n", Streaming.get_address());
        
        while (true) {        
            test_jpeg_snapshot_picture();    
            int n = Streaming.receive(recv_buffer, sizeof(recv_buffer));
            if (n <= 0) break; // n = n < 0
            
            // print received message to terminal
            recv_buffer[n] = '\0';
            if (EnDebugMSG)
            printf("Received message from Client :'%s'\r\n",recv_buffer);
            if(recv_buffer[0] == 'G' && recv_buffer[1] == 'E' && recv_buffer[2] == 'T')
            {
                char fname[64];
                snprintf(fname, sizeof(fname), "/fs/Stream.jpg");
                fp_jpeg = fopen(fname, "r");
                fseek(fp_jpeg, 0, SEEK_END);            // seek to end of file
                filesize = ftell(fp_jpeg);              // get current file pointer
                fseek(fp_jpeg, 0, SEEK_SET);            // seek back to beginning of file  
                
                sprintf(echoHeader,"HTTP/1.1 200 OK\r\nContent-Type: image/jpeg\r\nContent-Length: %lld\r\nConnection: close\r\nRefresh: 0.5\r\n\r\n", filesize);
                if (EnDebugMSG)
                printf("%s\r\n", echoHeader);
                Streaming.send_all(echoHeader,strlen(echoHeader));
                
                //wait(0.2);  //200ms important for browser!
                if (EnDebugMSG)
                printf("---filesize = %lld\r\n",filesize);
                all_send_bytes = 0;
                while(filesize)  
                {  //check for EOF !feof(fp)
                    
                    bytes_for_send = filesize;
                    if (bytes_for_send > sizeof(sentBuffer)) 
                    {
                        bytes_for_send = sizeof(sentBuffer);
                    }
                    fread (sentBuffer,1,bytes_for_send,fp_jpeg);
                    filesize -= bytes_for_send;
                    
                    if (EnDebugMSG)
                    printf("\r\n---bytes_for_send...%d",bytes_for_send);
                    
                    Streaming.send_all(sentBuffer,bytes_for_send);
                    //Thread::wait(10);
                    all_send_bytes += bytes_for_send;
                }
                if (EnDebugMSG)
                printf("\r\n---buffer fill end - all ...%lld\r\n", all_send_bytes);
                //binary send
                
                sprintf(line_response, "\r\n");
                Streaming.send_all(line_response,strlen(line_response));
                if ( fp_jpeg != NULL )
                fclose(fp_jpeg);       
            }
        }
    }
}

void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        if (EnDebugMSG)
        printf("[ OK ] : CameraC328::sync\r\n");
    } else {
        if (EnDebugMSG)
        printf("[FAIL] : CameraC328::sync (Error=%02X)\r\n", (int)err);
    }
}
void init() {
    CameraC328::ErrorNumber err = CameraC328::NoError;

#if (USE_JPEG_HIGH_RESOLUTION==1)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
#elif (USE_JPEG_HIGH_RESOLUTION==2)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
#elif (USE_JPEG_HIGH_RESOLUTION==3)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution320x240);
#elif (USE_JPEG_HIGH_RESOLUTION==4)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
#endif
    if (CameraC328::NoError == err) {
        if (EnDebugMSG)
        printf("[ OK ] : CameraC328::init\r\n");
    } else {
        if (EnDebugMSG)
        printf("[FAIL] : CameraC328::init (Error=%02X)\r\n", (int)err);
    }
}
void test_jpeg_snapshot_picture() {
    CameraC328::ErrorNumber err = CameraC328::NoError;
      
    char fname[64];
    snprintf(fname, sizeof(fname), "/fs/Stream.jpg");
    fp_jpeg = fopen(fname, "w");

    err = camera.getJpegSnapshotPicture(jpeg_callback);
    if (CameraC328::NoError == err) {
        if (EnDebugMSG)
        printf("[ OK ] : CameraC328::getJpegSnapshotPicture\n");
    } else {
        if (EnDebugMSG)
        printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\n", (int)err);
    }

    fclose(fp_jpeg);
}