#include "mbed.h"
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#include "CameraC328.h"

/* CAMERA */
#define USE_JPEG_HIGH_RESOLUTION  3 //1=80x64 <--- not working -_-;;, 2=160x128, 3=320x240, 4=640x480

/* FTP */
#define USER                "user "
#define PASS                "pass "
#define PASV                "pasv "
#define PORT                "port "
#define LIST                "list "
#define STOR                "stor "
#define RETR                "retr "
#define END                 "\r\n"
#define FTP_SERVER_PORT     21
#define MAX_SS              256
bool gDataSockReady = false;
bool gDataPutGetStart = false;
bool ftpclientrun = false;
int remote_port;
char ftpServer_data_ip_addr[4]={0,};
char ftpServer_data_ip_addr_str[20]={0,};
static char buf[256];
static char ID[]={"abc"};                   //Set FTPServer Login ID
static char PASSWORD[]={"123"};             //Set FTPServer Login Password
enum CommandFirst {
    f_nocmd,
    f_put,
};
enum CommandSecond {
    s_nocmd,
    s_put,
};
enum ftpc_datasock_state{
    DATASOCK_IDLE,
    DATASOCK_READY,
    DATASOCK_START
};
struct Command {
    enum CommandFirst First;
    enum CommandSecond Second;
};
struct ftpc {
    enum ftpc_datasock_state dsock_state;
};
struct ftpc FTPClient;
struct Command FTPCommand;

/* SD Card filesystem */
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 
static FILE *fp_jpeg;
char fname[32];
char fname_server[16];
char fnamecnt=0;
/* UART */
Serial pc(USBTX, USBRX);
char gMsgBuf[10];
char User_Keyboard_MSG_Cnt;
/* CAMERA */
CameraC328 camera(PA_13, PA_14, CameraC328::Baud115200);
/* Function*/ 
char* User_Keyboard_MSG(void);
int pportc(char * arg);
void jpeg_callback(char *buf, size_t siz);
void sync(void);
void test_jpeg_snapshot_picture(void);

int main() {

    char Msg_c;
    int remain_filesize;
    int send_byte;
    
    
    pc.baud(115200);
    
    pc.printf("Hello Home Security World!\r\n"); 
      
    uint8_t mac_addr[6] = {0x00, 0x08, 0xdc, 0x12, 0x34, 0x45};
    const char ip_addr[] = "192.168.0.123"; 
    const char mask_addr[] = "255.255.255.0"; 
    const char gateway_addr[] = "192.168.0.1"; 
    const char ftpServer_control_ip_addr[] = "192.168.0.2";
    
    
    EthernetInterface eth;
    eth.init(mac_addr, ip_addr, mask_addr, gateway_addr); //Use Static
    eth.connect();
    
    TCPSocketConnection FTP_CONTROL_SOCK;
    TCPSocketConnection FTP_DATA_SOCK;
    
    sync();
    //while 1
    while(true)
    {
        pc.printf("\r\n----------------------------------------\r\n");
        pc.printf("Press menu key\r\n");
        pc.printf("----------------------------------------\r\n");
        pc.printf("1> Snapshot Picture and Send FTPServer\r\n");
        pc.printf("----------------------------------------\r\n");
        Msg_c = pc.getc();
        if(Msg_c==0x31){
            
            test_jpeg_snapshot_picture();
            ftpclientrun = true;
            while(ftpclientrun){
                //while 2
                while(!FTP_CONTROL_SOCK.is_connected()){
                    pc.printf("Connecting...FTPServer\r\nIP:%s, PORT:%d\r\n", ftpServer_control_ip_addr, FTP_SERVER_PORT);
                    FTP_CONTROL_SOCK.connect(ftpServer_control_ip_addr, FTP_SERVER_PORT);
                    FTP_CONTROL_SOCK.set_blocking(false, 15000); // Timeout after (1.5)s
                }//end of while 2
                
                //while 3
                while(true)
                {  
                    //gDataSockReady if
                    if(gDataSockReady){
                        gDataSockReady = false;
                        //FTPCommand.First switch case
                        switch(FTPCommand.First){
                            case f_put:
                                FTP_CONTROL_SOCK.send(STOR, sizeof(STOR)-1);
                                FTP_CONTROL_SOCK.send(fname_server, sizeof(fname_server));
                                FTP_CONTROL_SOCK.send(END, sizeof(END)-1);
                                break;
                        }//end of FTPCommand.First switch case
                    }//end of gDataSockReady if          
                    /* received from FTPServer */
                    int n = FTP_CONTROL_SOCK.receive(buf, sizeof(buf));
                    if (n <= 0) break;
                    buf[n] = '\0';
                    pc.printf("\r\nReceived message from server: '%s'\r\n", buf);
                    
                    //buf if
                    if (!strncmp(buf, "220", 3)){
                        FTP_CONTROL_SOCK.send(USER, sizeof(USER)-1);
                        FTP_CONTROL_SOCK.send(ID, sizeof(ID));
                        FTP_CONTROL_SOCK.send(END, sizeof(END)-1);
                    }
                    else if(!strncmp(buf, "331", 3)){
                        FTP_CONTROL_SOCK.send(PASS, sizeof(PASS)-1);
                        FTP_CONTROL_SOCK.send(PASSWORD, sizeof(PASSWORD));
                        FTP_CONTROL_SOCK.send(END, sizeof(END)-1);        
                    }
                    else if(!strncmp(buf, "230", 3)){
                        FTP_CONTROL_SOCK.send(PASV, sizeof(PASV)-1);
                        FTP_CONTROL_SOCK.send(END, sizeof(END)-1);
                        FTPCommand.First = f_put;    
                    }
                    else if(!strncmp(buf, "227", 3)){
                        if (pportc(buf) == -1){
                            pc.printf("Bad port syntax\r\n");
                        }
                        else{
                            pc.printf("Go Open Data Sock...\r\n ");
                            FTPClient.dsock_state = DATASOCK_READY;
                        }    
                    }
                    else if(!strncmp(buf, "150", 3)){
                        switch(FTPCommand.First){
                        case f_put:
                            FTPCommand.First = f_nocmd;
                            FTPCommand.Second = s_put;
                            gDataPutGetStart = true;
                            break;
                        }  
                    }
                    else if(!strncmp(buf, "226", 3)){
                        ftpclientrun = false;  
                        FTP_CONTROL_SOCK.close();       
                    }//end of buf if
                    
                    
                    //DATASOCK_READY if
                    if(FTPClient.dsock_state == DATASOCK_READY){
                        while(!FTP_DATA_SOCK.is_connected()){
                            pc.printf("Connecting...FTPServer Data sock\r\nIP:%s, PORT:%d\r\n", ftpServer_data_ip_addr_str, remote_port);
                            FTP_DATA_SOCK.connect(ftpServer_control_ip_addr, remote_port);
                            FTP_DATA_SOCK.set_blocking(false, 15000); // Timeout after (1.5)s
                        }
                        FTPClient.dsock_state = DATASOCK_IDLE;
                        gDataSockReady = true;
                    }//end of DATASOCK_READY if
                    
                    //gDataPutGetStart if
                    if(gDataPutGetStart){
                        //FTPCommand.Second switch case
                        switch(FTPCommand.Second){   
                        case s_put:
                            pc.printf("put waiting...\r\n");
                            fp_jpeg = fopen(fname, "r");  
                            fseek(fp_jpeg, 0, SEEK_END);            // seek to end of file
                            remain_filesize = ftell(fp_jpeg);       // get current file pointer
                            fseek(fp_jpeg, 0, SEEK_SET);            // seek back to beginning of file                
                            do{
                                memset(buf, 0, sizeof(buf));
                                if(remain_filesize > MAX_SS)
                                    send_byte = MAX_SS;
                                else
                                    send_byte = remain_filesize;
                                fread (buf, 1, send_byte, fp_jpeg);
                                FTP_DATA_SOCK.send(buf, send_byte);
                                remain_filesize -= send_byte;
                                pc.printf("#");
                            }while(remain_filesize!=0);
                            fclose(fp_jpeg);
                            gDataPutGetStart = false; 
                            FTPCommand.Second = s_nocmd;     
                            FTP_DATA_SOCK.close(); 
                            break;   
                                
                        }//end of FTPCommand.Second switch case
                    }//end of gDataPutGetStart if
                }//end of while 3                
            }
        }
    }//end of while 1
}
char* User_Keyboard_MSG(void)
{
    User_Keyboard_MSG_Cnt = 0;
    memset(gMsgBuf, 0, sizeof(gMsgBuf));
    do{
        gMsgBuf[User_Keyboard_MSG_Cnt] = pc.getc();
        if(gMsgBuf[User_Keyboard_MSG_Cnt]==0x08){
            User_Keyboard_MSG_Cnt--;
        }
        else{
            User_Keyboard_MSG_Cnt++; 
        }
    }while(gMsgBuf[User_Keyboard_MSG_Cnt-1]!=0x0d);
    return gMsgBuf;
}
int pportc(char * arg)
{
    int i;
    char* tok=0;
    strtok(arg,"(");
    for (i = 0; i < 4; i++)
    {
        if(i==0) tok = strtok(NULL,",\r\n");
        else     tok = strtok(NULL,",");
        ftpServer_data_ip_addr[i] = (uint8_t)atoi(tok);
        if (!tok){
            pc.printf("bad pport : %s\r\n", arg);
            return -1;
        }
    }
    remote_port = 0;
    for (i = 0; i < 2; i++){
        tok = strtok(NULL,",\r\n");
        remote_port <<= 8;
        remote_port += atoi(tok);
        if (!tok){
            pc.printf("bad pport : %s\r\n", arg);
            return -1;
        }
    }
    pc.printf("ip : %d.%d.%d.%d, port : %d\r\n", ftpServer_data_ip_addr[0], ftpServer_data_ip_addr[1], ftpServer_data_ip_addr[2], ftpServer_data_ip_addr[3], remote_port);
    sprintf(ftpServer_data_ip_addr_str, "%d.%d.%d.%d", ftpServer_data_ip_addr[0], ftpServer_data_ip_addr[1], ftpServer_data_ip_addr[2], ftpServer_data_ip_addr[3]);
    return 0;
}
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}
void sync(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    err = camera.sync();
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::sync\r\n");
    } else {
        printf("[FAIL] : CameraC328::sync (Error=%02X)\r\n", (int)err);
    }
}
void test_jpeg_snapshot_picture(void) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

#if (USE_JPEG_HIGH_RESOLUTION==1)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution80x64);
#elif (USE_JPEG_HIGH_RESOLUTION==2)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution160x128);
#elif (USE_JPEG_HIGH_RESOLUTION==3)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution320x240);
#elif (USE_JPEG_HIGH_RESOLUTION==4)
    err = camera.init(CameraC328::Jpeg, CameraC328::RawResolution80x60, CameraC328::JpegResolution640x480);
#endif
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::init\r\n");
    } else {
        printf("[FAIL] : CameraC328::init (Error=%02X)\r\n", (int)err);
    }


    snprintf(fname, sizeof(fname), "/sd/jpss%04d.jpg", fnamecnt);
    fnamecnt++;
    for(int i = 0; i < 12; i++){
       fname_server[0+i] = fname[4+i]; 
    }
    fp_jpeg = fopen(fname, "w");

    err = camera.getJpegSnapshotPicture(jpeg_callback);
    if (CameraC328::NoError == err) {
        printf("[ OK ] : CameraC328::getJpegSnapshotPicture\r\n");
    } else {
        printf("[FAIL] : CameraC328::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
    }

    fclose(fp_jpeg);

}
