// Print "ascii table" to the serial port

#include "mbed.h"

Serial serial(USBTX, USBRX);

int thisByte = 33;

char *int2bin(unsigned value, char *buffer, const int buf_size) {
    buffer += (buf_size);
    int i = 8;
    do {
        *--buffer = (value & 1) + '0';
        value >>= 1;
    }
    while(--i);

    return buffer;
}

int main()
{
    serial.printf("ASCII Table ~ Character Map\r\n");
    
    char buff[34];
    buff[33] = 0;
    do
    {
        // prints value unaltered, i.e. the raw binary version of the
        // byte. The serial monitor interprets all bytes as
        // ASCII, so 33, the first number,  will show up as '!'
        serial.printf("%c:", thisByte);
        serial.printf(", dec: %d", thisByte);
        serial.printf(", hex: 0x%x", thisByte);
        serial.printf(", oct: \\0%o", thisByte);
        serial.printf(", bin: %s\r\n", int2bin(thisByte,buff,33));
    } while(++thisByte < 127);
}