#include "mbed.h"

// Biblioteca para utilização do LCD Display
#include "C12832.h"

AnalogIn   sensor(p15);

// Visualização PWM
PwmOut pwm(p21);

// Inicialização padrão para LCD
C12832 lcd(p5, p7, p6, p8, p11);

int main(void)
{
    lcd.cls();

    // Codigo PWM
    pwm.period_ms(10);
    pwm.write(0.5f);

    while (1) {


        // Print the % value and the absolute value from the sensor at p15
        lcd.locate(0,3);
        lcd.printf( "Percentage: %3.3f%% \n", (1-sensor.read()) * 100.0f );
        lcd.printf( "Absolute Value: %2.3f", 1-sensor.read() );
        wait(0.5f);
        lcd.cls();
    }
}