#include "mbed.h"
#include "LSM6DSLSensor.h"

int main() {
  uint8_t id;
  int32_t axes[3];
  DevI2C  *dev_i2c = new DevI2C(D14, D15);
  LSM6DSLSensor *acc_gyro = new LSM6DSLSensor(dev_i2c, LSM6DSL_ACC_GYRO_I2C_ADDRESS_LOW, A2, A3);

  acc_gyro->enable_x();
  acc_gyro->enable_g();

  printf("\r\nLSM6DSL example\r\n");

  acc_gyro->read_id(&id);
  printf("LSM6DSL accelerometer & gyroscope = 0x%X\r\n", id);

  while(1) {
    acc_gyro->get_x_axes(axes);
    printf("LSM6DSL [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    acc_gyro->get_g_axes(axes);
    printf("LSM6DSL [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    wait(0.2); // 200 ms
  }
}