#ifndef __USB_ENUMS_H__
#define __USB_ENUMS_H__

enum TransferCompletionCode
{
    /**
     * General TD or isochronous data packet processing completed with no detected errors
     */
    TCC_NOERROR = 0,
    
    /**
     * Last data packet from endpoint contained a CRC error.
     */
    TCC_CRC = 1,

    /**
     * Last data packet from endpoint contained a bit stuffing violation
     */
    TCC_BITSTUFFING = 2,
    
    /**
     * Last packet from endpoint had data toggle PID that did not match the expected value.
     */
    TCC_DATATOGGLEMISMATCH = 3,
    
    /**
     * TD was moved to the Done Queue because the endpoint returned a STALL PID
     */
    TCC_STALL = 4,
    
    /**
     * Device did not respond to token (IN) or did not provide a handshake (OUT)
     */
    TCC_DEVICENOTRESPONDING = 5,
    
    /**
     * Check bits on PID from endpoint failed on data PID (IN) or handshake (OUT)
     */
    TCC_PIDCHECKFAILURE = 6,
    
    /**
     * Receive PID was not valid when encountered or PID value is not defined.
     */
    TCC_UNEXPECTEDPID = 7,
    
    /**
     * The amount of data returned by the endpoint exceeded either the size of the maximum data packet allowed from the endpoint (found in MaximumPacketSize field of ED) or the remaining buffer size.
     */
    TCC_DATAOVERRUN = 8,
    
    /**
     * The endpoint returned less than MaximumPacketSize and that amount was not sufficient to fill the specified buffer
     */
    TCC_DATAUNDERRUN = 9,
    
    //
    TCC_reserved1 = 10,
    
    //
    TCC_reserved2 = 11,
    
    /**
     * During an IN, HC received data from endpoint faster than it could be written to system memory
     */
    TCC_BUFFEROVERRUN = 12,
    
    /**
     * During an OUT, HC could not retrieve data from system memory fast enough to keep up with data USB data rate.
     */
    TCC_BUFFERUNDERRUN = 13,
};

enum ControlTransferState
{
    CTS_IDLE   = 0,
    CTS_SETUP  = 1,
    CTS_DATA   = 2,
    CTS_ACK    = 3
};

enum DataToggle
{
    TOGGLE_DATA0 = 2,
    TOGGLE_DATA1 = 3,
};

enum TransferDescriptorDirection
{
    TDD_SETUP = 0,
    TDD_OUT = 1,
    TDD_IN = 2,
    TDD_RESERVED = 3,
};

enum TransferType
{
    TT_CONTROL = 1,
    TT_BULK = 2,
};

enum libusb_endpoint_direction
{
    LIBUSB_ENDPOINT_IN = 0x80,
    LIBUSB_ENDPOINT_OUT = 0x00
};

enum libusb_descriptor_type
{
    LIBUSB_DT_DEVICE = 0x01,
    LIBUSB_DT_CONFIG = 0x02,
    LIBUSB_DT_STRING = 0x03,
    LIBUSB_DT_INTERFACE = 0x04,
    LIBUSB_DT_ENDPOINT = 0x05,
    LIBUSB_DT_INTERFACE_ASSOCIATION = 0x0A,
    LIBUSB_DT_HID = 0x21,
    LIBUSB_DT_REPORT = 0x22,
    LIBUSB_DT_PHYSICAL = 0x23,
    LIBUSB_DT_HUB = 0x29,
};

enum libusb_standard_request
{
    LIBUSB_REQUEST_GET_STATUS = 0x00,
    LIBUSB_REQUEST_CLEAR_FEATURE = 0x01,
    /* 0x02 is reserved */
    LIBUSB_REQUEST_SET_FEATURE = 0x03,
    /* 0x04 is reserved */
    LIBUSB_REQUEST_SET_ADDRESS = 0x05,
    LIBUSB_REQUEST_GET_DESCRIPTOR = 0x06,
    LIBUSB_REQUEST_SET_DESCRIPTOR = 0x07,
    LIBUSB_REQUEST_GET_CONFIGURATION = 0x08,
    LIBUSB_REQUEST_SET_CONFIGURATION = 0x09,
    LIBUSB_REQUEST_GET_INTERFACE = 0x0A,
    LIBUSB_REQUEST_SET_INTERFACE = 0x0B,
    LIBUSB_REQUEST_SYNCH_FRAME = 0x0C,
};

enum libusb_request_type
{
    LIBUSB_REQUEST_TYPE_STANDARD = (0x00 << 5),
    LIBUSB_REQUEST_TYPE_CLASS = (0x01 << 5),
    LIBUSB_REQUEST_TYPE_VENDOR = (0x02 << 5),
    LIBUSB_REQUEST_TYPE_RESERVED = (0x03 << 5)
};

enum libusb_request_recipient
{
    LIBUSB_RECIPIENT_DEVICE = 0x00,
    LIBUSB_RECIPIENT_INTERFACE = 0x01,
    LIBUSB_RECIPIENT_ENDPOINT = 0x02,
    LIBUSB_RECIPIENT_OTHER = 0x03,
};

#endif//#ifndef __USB_ENUMS_H__
