
#ifndef __DISPLAY1602_H__
#define __DISPLAY1602_H__

#include "mbed.h"
#include <stdarg.h>

/*
INITIALIZING BY INSTRUCTION
1) 8-bit interface mode (Condition: fosc = 270KHZ)

Codes
N = 0 1-line mode , 1 2-line mode
D = 0 display off, 1 display on
C = 0 cursor off, 1 cursor on
B = 0 blink off, 1 blink on
I/D = 0 decrement mode, 1 increment mode
SH = 0 entire shift off, 1 entire shift on


***        Power on
Wait for more than 30 ms after VDD rises to 4.5 v

***        Function set
RS R/W DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0
 0  0   0   0   1   1   N   D   X   X
Wait for more than 39 &#956;s

***        Display ON/OFF Control
RS R/W DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0
 0  0   0   0   0   0   1   D   C   B
Wait for more than 39 &#956;s


***        Display Clear
RS R/W DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0
 0  0   0   0   0   0   0   0   0   1
Wait for more than 1.53 ms

***        Entry Mode Set
RS R/W DB7 DB6 DB5 DB4 DB3 DB2 DB1 DB0
 0   0  0   0   0   0   0   1  I/D SH

***        Initialization end     ***


*/

/** Basic bit of code for using a standard 1602 display in 8 bit mode.
 * Written by Richard e Collins.
 * Basic bit of code for using a standard 1602 display in 8 bit mode.
 * When wiring one of these displays up make sure the power to the LCD on pin 3 is correct, too high and it will not display anything. About 0.2v is good, I use a POT to set it.
 *
 * Example use.
 *   Display1602 display(p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20);
 *   display.SetXY(0,0);
 *   display.Print("Hello world");
 */
struct Display1602
{
    /**
     * Constructor, here you state the oins used to read and write data on and the control pins.
     * @param registerSelect This is the pin used to select if you are sending data or setting a control register.
     * @param readWriteSelect The pin to state if you are reading or writing data / register.
     * @param d0 -> d7. The eight pins for the data to be either written to the display or a register.
     */
    Display1602(PinName registerSelect,PinName readWriteSelect,PinName readWriteEnable,PinName d0,PinName d1,PinName d2,PinName d3,PinName d4,PinName d5,PinName d6,PinName d7) ;

    /**
     * Clears the display.
     */    
    void Clear();
    
    /**
     * Prints the text to the display, will limit the chars read by 16 chars or hitting a null terminator, which ever comes first.
     * Advances the cursor pos.
     */
    void Print(const char *text);
    
    /**
     * handy printf funtion for displaying text.
     * Advances the cursor pos.
     */
    void printf(const char *format,...);

    /**
     *Sets the cusor X Y pos.
     */
    void SetXY(int x,int y);
    
private:
    DigitalOut rs;     //Register select, high value in data is data char data, when low is a command.
    DigitalOut rw;    //Data direction, high read operation, low is write operation.
    DigitalOut e;    //When high the value in data is read from or written to the register selected. 
    BusOut data;    //The data sent.
    
    void SendCommand(int cmd);
    
    void SendChar(char c);
};

#endif //#ifndef __DISPLAY1602_H__
