
#include "Display1602.h"

 Display1602::Display1602(PinName registerSelect,PinName readWriteSelect,PinName readWriteEnable,PinName d0,PinName d1,PinName d2,PinName d3,PinName d4,PinName d5,PinName d6,PinName d7) 
        : rs(registerSelect), rw(readWriteSelect), e(readWriteEnable), data(d0,d1,d2,d3,d4,d5,d6,d7)
{
    //To ensure we have waited 15ms after power up and VDD > 4.5v (don't know how to test VDD)
    wait_ms(20);
    
    //The init commands always sent using the 4bit interface.
    e = true;
    
    //Set interface to 8 bit mode
    SendCommand(0x38);
    wait_ms(1); 
    
    //Display off
    SendCommand(0x08);
    wait_ms(1); 
    
    Clear();
    
    //Set the display to 2 line and 5x11 font.
    SendCommand(0x06);
    wait_ms(1); 
    
    //Init done, turn display on.
    SendCommand(0x0c); //No with no cursor.
    wait_ms(10);   
}

void Display1602::Clear()
{
    SendCommand(0x01);
    wait_ms(2);//Docs say have to wait more than 1.53 milliseconds after clearing display.
}

void Display1602::Print(const char *text)
{
    int n = 16;
    while (*text && n--)
    {
        SendChar(*text);
        text++;
    }
}

void Display1602::printf(const char *format,...)
{
    va_list args;
    char buf[17];

    va_start(args, format);
    vsnprintf(buf,17,format, args);
    va_end(args);
    
    Print(buf);        
}

void Display1602::SetXY(int x,int y)
{
    if (y == 0)
    {
        SendCommand (0x80 | x);
    }
    else
    {
        SendCommand (0xC0 | x);
    }
}
    
void Display1602::SendCommand(int cmd)
{
    rs = false;//read register
    rw = false;//Write mode
    e = true;
    data = cmd;
    wait_us(40);//Have to wait this time before we then drop the e line. Data sent on rising edge so has to be dropped.
    e = false;
}

void Display1602::SendChar(char c)
{
    rs = true;//Writing data.
    rw = false;//Write mode
    e = true;
    data = c;
    wait_us(40);//Have to wait this time before we then drop the e line. Data sent on rising edge so has to be dropped.
    e = false;
}
    