#include "Filter.h"

double Filter(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2, const double gain){
    // volgens direct form 2, uit de embedded filtering and control sheets van T.J.W. Lankhorst
    // u = ingangssignaal (zonder filter)
    // v = tussentap
    // v1 = v bij u(x-1), dus v van 1 geleden
    // v2 = v bij u(x-2), dus v van 2 geleden
    // a1 en a2 variabele uit ASN filter, a0 =1
    // b0, b1, b2 variabele uit ASN filter
    // y = uitgangssignaal (gefilterd)
    
    double v = u - a1 * v1 - a2 * v2;
    double y = gain * (b0 * v + b1 * v1 + b2 * v2);
    
    v2 = v1; // signalen doorschuiven, zodat bij de volgende input, de vorige waardes van v worden onthouden
    v1 = v; 
    
    return y;
    }