#include "Kalibratie.h"
#include "Filterdesigns.h"
//#include "MODSERIAL.h" //bugfix

//AnalogIn    emg2(A0); //Analog input van emg kabels
//MODSERIAL   pc2(USBTX, USBRX); //bugfix
DigitalOut  LedGreen(LED2);
DigitalOut  LedRed(LED1);

int samples = 100;

void Init(){
    LedGreen = 1;
    LedRed = 1;
}

double KalibratieMax(AnalogIn& emg, bool side){  //Kalibratie van de maximum waarde
    LedGreen.write(0); //Led aan
    double ymax = 0;
    
    for(int i = 1; i <= samples; i++) { //Als timer onder de 5 seconden is dit uitvoeren        
        double u = emg.read();
        double y = 0;
        if(side){                               // links 
            y = FilterdesignsLeft(u);
            }
        else {
            y = FilterdesignsRight(u);           // rechts
            }        
        if (y > ymax && i >= samples / 10) { //Als de gemeten waarde groter is dan de opgeslagen waarde wordt dit de nieuwe opgeslagen waarde
            ymax = y;
            }        
        wait(0.05);
        }                 
    LedGreen.write(1); //Led aan    
    return ymax;
    }

double KalibratieMin(AnalogIn& emg, bool side){  //Kalibratie van de minimum waarde   
    LedRed.write(0);
    double ymin = 10;

    for(int i = 1; i <= samples; i++) {
        double u = emg.read();
        double y = 0;
        if(side){                               // links 
            y = FilterdesignsLeft(u);
            }
        else {
            y = FilterdesignsRight(u);           // rechts
            }        
        
        if (y < ymin && i >= samples / 10) {
            ymin = y;
            }      
        wait(0.05);
        }            
    LedRed.write(1);
    return ymin;
}