#include "Filterdesigns.h"
#include "Filter.h"

// Inputwaardes
//Notch 50Hz

// Filter1a: 50Hz Notch
double v1_50a_L = 0, v2_50a_L = 0;
double v1_50a_R = 0, v2_50a_R = 0;
const double a1_50a = -1.52337295428, a2_50a = 0.93195385841;
const double b0_50a = 1.00000000000, b1_50a = -1.61854514929, b2_50a = 1.0;
const double gain_50a = 1.000000;

// Filter1b: 50Hz Notch
double v1_50b_L = 0, v2_50b_L = 0;
double v1_50b_R = 0, v2_50b_R = 0;
const double a1_50b = -1.60486796113, a2_50b = 0.93780356783;
const double b0_50b = 1.00000000000, b1_50b = -1.61854514929, b2_50b = 1.0;
const double gain_50b = 0.934872;

//HighPass 20Hz

// Filter2a: 20Hz HighPass
double v1_HP_L = 0, v2_HP_L = 0;
double v1_HP_R = 0, v2_HP_R = 0;
const double a1_HP = -0.76475499450, a2_HP = 0.27692273367;
const double b0_HP = 1.00000000000, b1_HP = -2.0, b2_HP = 1.00000000000;
const double gain_HP = 0.510419;

//LowPass 3Hz

// Filter3a: 3Hz LowPass
double v1_LP_L = 0, v2_LP_L = 0;
double v1_LP_R = 0, v2_LP_R = 0;
const double a1_LP = -1.93503824887, a2_LP = 0.93708289663;
const double b0_LP = 1.00000000000, b1_LP = 2.0, b2_LP = 1.00000000000;
const double gain_LP = 0.000511;



double FilterdesignsLeft(double u){   // input u, oude y waarde
    double y = 0;    
    //u = input waarde
    //y = output waarde
    
    // Op deze manier worden de waardes ingelezen in Filter. Zorg dus voor dezelfde volgorde, zodat de waardes goed uitgelezen worden!:
    // Filter(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2, const double gain)

    // 50Hz Notch filter
    double y50a = Filter(u, v1_50a_L, v2_50a_L, a1_50a, a2_50a, b0_50a, b1_50a, b2_50a, gain_50a);
    double y50b = Filter(y50a, v1_50b_L, v2_50b_L, a1_50b, a2_50b, b0_50b, b1_50b, b2_50b, gain_50b);

    // High Pass filter. Tot 20Hz wordt weggefliterd              
    double yHP = Filter(y50b, v1_HP_L, v2_HP_L, a1_HP, a2_HP, b0_HP, b1_HP, b2_HP, gain_HP);

    // Absolute waarde wordt genomen
    double y1 = fabs(yHP);

    // Low Pass filter. Alles vanaf 5Hz wordt weggefilterd
    double yLP = Filter(y1, v1_LP_L, v2_LP_L, a1_LP, a2_LP, b0_LP, b1_LP, b2_LP, gain_LP);

    y = 10 * yLP;    
    return y;
    }
    
double FilterdesignsRight(double u){   // input u, oude y waarde
    //u = input waarde
    //y = output waarde
    
    // Op deze manier worden de waardes ingelezen in Filter. Zorg dus voor dezelfde volgorde, zodat de waardes goed uitgelezen worden!:
    // Filter(double u, double &v1, double &v2, const double a1, const double a2, const double b0, const double b1, const double b2, const double gain)

    // 50Hz Notch filter
    double y50a = Filter(u, v1_50a_R, v2_50a_R, a1_50a, a2_50a, b0_50a, b1_50a, b2_50a, gain_50a);
    double y50b = Filter(y50a, v1_50b_R, v2_50b_R, a1_50b, a2_50b, b0_50b, b1_50b, b2_50b, gain_50b);

    // High Pass filter. Tot 20Hz wordt weggefliterd              !!!  WAT IS HIER INPUT U? !!!
    double yHP = Filter(u, v1_HP_R, v2_HP_R, a1_HP, a2_HP, b0_HP, b1_HP, b2_HP, gain_HP);

    // Absolute waarde wordt genomen.
    double y1 = fabs(yHP);

    // Low Pass filter. Alles vanaf 5Hz wordt weggefilterd
    double yLP = Filter(y1, v1_LP_R, v2_LP_R, a1_LP, a2_LP, b0_LP, b1_LP, b2_LP, gain_LP);

    double y = 10 * yLP;    
    return y;
}

