
#include "mbed.h"
#include "Serial_HL.h"
#include "FuncGenFSST.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();
void ExecSignalChain();

SignedRampGen fg1;
float ampl1=1.0;
float v1=0;

int main(void)
{
	pc.format(8,SerialBLK::None,1);
	pc.baud(500000);
	ua0.SvMessage("FuncGen1_1"); 
	
	Timer stw; stw.start();
	while(1) {
		CommandHandler();
		if( stw.read_ms()>10 ) { // 100Hz
			stw.reset();
			ExecSignalChain();
			if( ua0.acqON ) {
				ua0.WriteSV(1, v1);
			}
		}
	}
	return 1;
}

void ExecSignalChain()
{
	fg1.CalcOneStep();
	v1 = fg1.val*ampl1;
}

void CommandHandler()
{
	uint8_t cmd;
	if( !pc.IsDataAvail() )
			return;
	cmd = ua0.GetCommand();
	
	if( cmd==2 ) { // Frequenz verstellen
	  fg1.SetFrequ(ua0.ReadF());
		ua0.SvMessage("Set Frequ.");
	}
	
	if( cmd==3 ) { // Amplitude verstellen
	  ampl1=ua0.ReadF();
		ua0.SvMessage("Set Ampl.");
	}
}
















