#include "mbed.h"
#define motor_addr 0x91
//I2C settings
#define SDA D14
#define SCL D15
#define I2C_BUFFER_SIZE 10
I2CSlave slave(SDA,SCL);

#define CURVE_BUFFER_SIZE 100

//Curve settings
float curve_buffer[CURVE_BUFFER_SIZE];
float curve_min=80;    //[mmHg]
float curve_max=120;   //[mmHg]
float curve_period=10; //[ms]

//Note: om de frequentie aan te passen speel je de buffer sneller af. Hierbij neemt nauwkeurigheid wel af. Om dit te verminderen
//heb je meer punten in de buffer nodig.
float curve_sinus(){
    float amplitude = (curve_max - curve_min)/2; //amplitude*sin(t) //van -amplitude naar +amplitude
    //Als sin(x) = 0, moet de curve exact in het midden van max en min zitten
    float offset = (curve_max+curve_min)/2;
    //Genereer een volle periode en zet het in de buffer
    float step = 2*3.1415926/CURVE_BUFFER_SIZE;
    for(int i=0;i<CURVE_BUFFER_SIZE;i++){        
        curve_buffer[i] = offset+amplitude*sin(step*x);
    }
}

float curve_arterial(){
    //Help.   
}


int main() {
    slave.address(motor_addr); //Set the correct address for this module
    char buffer[I2C_BUFFER_SIZE] = {0}; //Create the buffer for I2C
    bool buffer_changed;
    while(1) {
        int i = slave.receive();        
        switch (i) {
            case I2CSlave::ReadAddressed:
                //Received a request to be read
                //Irrelevant for now
                break;
            case I2CSlave::WriteGeneral:
                //Received a request to be written to
                slave.read(buffer,I2C_BUFFER_SIZE);
                buffer_changed = true;
                break;
            case I2CSlave::WriteAddressed:
                //Received a request to be written to a specific location
                slave.read(buffer,I2C_BUFFER_SIZE);
                buffer_changed = true;
                break;
        }
        //Do shit depending on the command it received in the first data block
        if(buffer_changed == true){
            int command = buffer[0];
            switch(command){
                case 0: 
                    break;
                case 1:
                    break;
                case 2:
                    break;  
                case default:
                    //No command was valid
                    //Create some kind of error? Maybe, blinking led.
                    break;  
            } 
                
        }
        //Clear the buffer for the next iteration
        if(buffer_changed == true){
            for(int i=0;i<I2C_BUFFER_SIZE;i++){
                buffer[i] = 0;    
            }
            buffer_changed = false;
        }
        
    }
}
