#include "mbed.h"
#include "Gameduino.h"

int main() {
    // Make a digital output for use with Gameduino.
    DigitalOut cs( p8 );
    // Initialise an SPI link for communications with Gameduino.
    // Use pin 5 for MOSI.
    // Use pin 6 for MISO.
    // Use pin 7 for SCK.
    SPI spi( p5, p6, p7 );
    // 8MHz clock should be OK.
    spi.frequency( 8000000 );
    // Set SPI format to use.
    // Use 8 bits per SPI frame.
    // Use SPI mode 0.
    spi.format( 8, 0 );
    // Make a Gameduino and pass SPI link and digital output for chip select.
    Gameduino gd( &spi, &cs );
    // Reset the Gameduino.
    gd.begin();
    // Lets have a default ASCII character set.
    gd.ascii();
    // Write something to character memory.
    gd.__wstart( Gameduino::RAM_PIC );
    for( UInt8 c = 'A'; c <= 'Z'; ++c ) {
        gd.__tr8( c );
    }
    gd.__end();
    // Test copy method.
    UInt8 copyData[] = "HELLO";
    gd.copy( Gameduino::RAM_PIC + 64, copyData, 5 );
    // Test putstr method.
    gd.putstr( 3, 10, "Ambidextrous!" );
    // Finished with Gameduino.
    gd.end();
}
