/*
 * SOURCE FILE : Rectangle.h
 *
 * Definition of class Rectangle.
 * Represents a rectangular area.
 *
 */

#ifndef RectangleDefined

  #define RectangleDefined

  #include "Types.h"
  
  class Rectangle {

  public :

    // Coordinates of top left.
    Int16 X1, Y1;
    
    // Coordinates of bottom right.
    Int16 X2, Y2;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    Rectangle();

    /***************/
    /* CONSTRUCTOR */
    /***************/
    // Pass coordinates of top left in x1 and y1.
    // Pass coordinates of bottom right in x2 and y2.
    Rectangle( Int16 x1, Int16 y1, Int16 x2, Int16 y2 );

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~Rectangle();

    /*******************/
    /* CALCULATE WIDTH */
    /*******************/
    // Returns width of rectangle.
    Int16 GetWidth( void ) const {
      return X2 - X1 + 1;
    }
    
    /********************/
    /* CALCULATE HEIGHT */
    /********************/
    // Returns height of rectangle.
    Int16 GetHeight( void ) const {
      return Y2 - Y1 + 1;
    }
    
  };

#endif

/* END of Rectangle.h */

