/*
 * SOURCE FILE : PlayerName.cpp
 *
 * Definition of class PlayerName.
 * Contains the name that appears in a high score table for example.
 *
 */

#include "PlayerName.h"

/***************/
/* CONSTRUCTOR */
/***************/
PlayerName::PlayerName() {
  // Initialise name to all 'X' characters.
  for( UInt8 i = 0; i < Length; ++i ) {
    Name[ i ] = 'X';
  }
  Name[ Length ] = (char)0;
}

/**************/
/* DESTRUCTOR */
/**************/
PlayerName::~PlayerName() {
}

/************************************************************/
/* COPY ONE NAME TO ANOTHER WITHOUT CREATING A NEW INSTANCE */
/************************************************************/
// Pass pointer to name to copy to in dest.
void PlayerName::CopyTo( PlayerName *dest ) const {
  for( UInt8 i = 0; i < Length; ++i ) {
    dest->Name[ i ] = Name[ i ];
  }
  dest->Name[ Length ] = (char)0;
}

