/*
 * SOURCE FILE : OneShotObject.cpp
 *
 * Base class for all objects that do not move and play an animation once before vanishing.
 * Useful for explosions and popup scores.
 *
 */

#include "OneShotObject.h"

/************************/
/* MOVE THE GAME OBJECT */
/************************/
void OneShotObject::ProtectedMove( void ) {
  if( imageCountdown > 0 ) {
    // Not time to change image yet.
    imageCountdown--;
  }
  else if( imageNumber >= lastImageNumber ) {
    // Animation completed. Make game object invisible.
    Visible = false;
  }
  else {
    // Move on to next image in the animation.
    imageNumber++;
    imageCountdown = maxCountdown;
  }
}

